
import gurobi

# Create a new model
m = gurobi.Model()

# Define the variables
x0 = m.addVar(name='blueberry_pies', vtype=gurobi.GRB.INTEGER)  # integer
x1 = m.addVar(name='steaks')  # continuous
x2 = m.addVar(name='chicken_drumsticks', vtype=gurobi.GRB.INTEGER)  # integer
x3 = m.addVar(name='oreos')  # continuous

# Define the objective function
m.setObjective(2.01*x0**2 + 5.65*x0*x1 + 1.91*x0*x3 + 7.05*x1**2 + 6.82*x1*x2 + 2.36*x1*x3 + 7.51*x2**2 + 4.68*x3**2 + 7.09*x0 + 3.26*x1 + 1.66*x2, gurobi.GRB.MAXIMIZE)

# Add constraints
m.addConstr(14*x0 + 2*x1 + 9*x2 + 2*x3 <= 229)
m.addConstr(20*x0 + 14*x1 + 14*x2 + x3 <= 163)
m.addConstr(2*x1 + 2*x3 >= 35)
m.addConstr(14*x0 + 9*x2 >= 45)
m.addConstr(14**2*x0**2 + 2**2*x3**2 >= 31)
m.addConstr(2*x1 + 9*x2 + 2*x3 >= 46)
m.addConstr(14**2*x0**2 + 9**2*x2**2 + 2**2*x3**2 >= 46)
m.addConstr(2*x1 + 9*x2 + 2*x3 >= 37)
m.addConstr(14**2*x0**2 + 9**2*x2**2 + 2**2*x3**2 >= 37)
m.addConstr(14*x1 + x3 >= 20)
m.addConstr(20*x0 + 14*x2 >= 28)
m.addConstr(20**2*x0**2 + 14**2*x1**2 >= 17)
m.addConstr(14*x1 + 14*x2 >= 38)
m.addConstr(2*x1 + 2*x3 <= 93)
m.addConstr(14*x0 + 2*x1 <= 209)
m.addConstr(14*x0 + 2*x1 + 9*x2 + 2*x3 <= 209)
m.addConstr(20**2*x0**2 + 14**2*x2**2 <= 91)
m.addConstr(14**2*x2**2 + x3**2 <= 60)
m.addConstr(14*x1 + 14*x2 <= 135)
m.addConstr(20**2*x0**2 + 14**2*x1**2 <= 83)
m.addConstr(14**2*x1**2 + 14**2*x2**2 + x3**2 <= 122)
m.addConstr(20*x0 + 14*x1 + 14*x2 + x3 <= 122)

# Solve the model
m.optimize()

# Print the solution
if m.status == gurobi.GRB.OPTIMAL:
    print('Objective: ', m.objVal)
    print('Blueberry pies: ', x0.varValue)
    print('Steaks: ', x1.varValue)
    print('Chicken drumsticks: ', x2.varValue)
    print('Oreos: ', x3.varValue)
else:
    print('No optimal solution found')
