
import gurobipy as gp
from gurobipy import GRB

try:
    # Create a new model
    model = gp.Model("optimization_problem")

    # Create variables
    x0 = model.addVar(vtype=GRB.INTEGER, name="hours worked by Ringo")
    x1 = model.addVar(vtype=GRB.INTEGER, name="hours worked by Mary")
    x2 = model.addVar(vtype=GRB.CONTINUOUS, name="hours worked by Bobby")


    # Set objective function
    model.setObjective(9.51 * x0 + 2.54 * x1 + 2.66 * x2, GRB.MINIMIZE)

    # Add constraints
    model.addConstr(22 * x0 + 21 * x1 >= 26, "c1")
    model.addConstr(22 * x0 + 21 * x1 + 22 * x2 >= 26, "c2")
    model.addConstr(2 * x1 + 22 * x2 >= 16, "c3")
    model.addConstr(14 * x0 + 2 * x1 >= 12, "c4")
    model.addConstr(14 * x0 + 22 * x2 >= 18, "c5")
    model.addConstr(14 * x0 + 2 * x1 + 22 * x2 >= 18, "c6")
    model.addConstr(4 * x1 - 10 * x2 >= 0, "c7")
    model.addConstr(22 * x0 + 21 * x1 <= 138, "c8")
    model.addConstr(22 * x0 + 21 * x1 + 22 * x2 <= 184, "c9")
    model.addConstr(14 * x0 + 2 * x1 <= 59, "c10")
    model.addConstr(2 * x1 + 22 * x2 <= 48, "c11")
    model.addConstr(14 * x0 + 22 * x2 <= 29, "c12")


    # Optimize model
    model.optimize()

    if model.status == GRB.OPTIMAL:
        print('Obj: %g' % model.objVal)
        for v in model.getVars():
            print('%s %g' % (v.varName, v.x))
    elif model.status == GRB.INFEASIBLE:
        print("The model is infeasible.")
    else:
        print(f"Optimization ended with status {model.status}")


except gp.GurobiError as e:
    print('Error code ' + str(e.errno) + ': ' + str(e))

except AttributeError:
    print('Encountered an attribute error')
