
import gurobi

def solve_optimization_problem():
    # Create a new model
    model = gurobi.Model()

    # Define the variables
    x0 = model.addVar(name='x0', vtype=gurobi.GRB.INTEGER)  # hours worked by Ringo
    x1 = model.addVar(name='x1', vtype=gurobi.GRB.INTEGER)  # hours worked by Mary
    x2 = model.addVar(name='x2')  # hours worked by Bobby

    # Set the objective function
    model.setObjective(9.51 * x0 + 2.54 * x1 + 2.66 * x2, gurobi.GRB.MINIMIZE)

    # Add constraints
    model.addConstr(22 * x0 >= 22 * x0)
    model.addConstr(14 * x0 >= 14 * x0)
    model.addConstr(21 * x1 >= 21 * x1)
    model.addConstr(2 * x1 >= 2 * x1)
    model.addConstr(22 * x2 >= 22 * x2)
    model.addConstr(22 * x2 >= 22 * x2)
    model.addConstr(22 * x0 + 21 * x1 >= 26)
    model.addConstr(22 * x0 + 21 * x1 + 22 * x2 >= 26)
    model.addConstr(2 * x1 + 22 * x2 >= 16)
    model.addConstr(14 * x0 + 2 * x1 >= 12)
    model.addConstr(14 * x0 + 22 * x2 >= 18)
    model.addConstr(14 * x0 + 2 * x1 + 22 * x2 >= 18)
    model.addConstr(4 * x1 - 10 * x2 >= 0)
    model.addConstr(22 * x0 + 21 * x1 <= 138)
    model.addConstr(22 * x0 + 21 * x1 + 22 * x2 <= 184)
    model.addConstr(14 * x0 + 2 * x1 <= 59)
    model.addConstr(2 * x1 + 22 * x2 <= 48)
    model.addConstr(14 * x0 + 22 * x2 <= 29)

    # Solve the model
    model.optimize()

    # Print the solution
    if model.status == gurobi.GRB.OPTIMAL:
        print('Objective: ', model.objval)
        print('x0: ', x0.varValue)
        print('x1: ', x1.varValue)
        print('x2: ', x2.varValue)
    else:
        print('No solution found')

solve_optimization_problem()
