
import gurobipy as gp

# Create a new model
m = gp.Model("optimization_problem")

# Create variables
x = m.addVars(6, lb=0, vtype=gp.GRB.INTEGER, names=[
    "wooden pencils", "postage stamps", "red highlighters", "scissors", "headsets", "usb flash drives"
])

# Set objective function
m.setObjective(
    7.25 * x[0] + 1.62 * x[1] + 9.82 * x[2] + 2.87 * x[3] + 7.61 * x[4] + 4.6 * x[5],
    gp.GRB.MAXIMIZE
)

# Add constraints
weights = [4, 17, 9, 12, 17, 17]
m.addConstr(sum(weights[i] * x[i] for i in range(6)) <= 248)
m.addConstr(12 * x[3] + 17 * x[5] >= 32)
m.addConstr(4 * x[0] + 9 * x[2] >= 16)
m.addConstr(12 * x[3] + 17 * x[4] >= 23)
m.addConstr(4 * x[0] + 17 * x[4] >= 27)
m.addConstr(4 * x[0] + 12 * x[3] >= 37)
m.addConstr(4 * x[0] + 17 * x[1] >= 26)
m.addConstr(17 * x[1] + 17 * x[4] >= 15)
m.addConstr(17 * x[1] + 12 * x[3] >= 40)
m.addConstr(17 * x[1] + 9 * x[2] >= 40)
m.addConstr(17 * x[1] + 17 * x[5] >= 37)
m.addConstr(4 * x[0] + 17 * x[1] + 12 * x[3] >= 26)
m.addConstr(17 * x[1] + 17 * x[4] + 17 * x[5] >= 26)
m.addConstr(4 * x[0] + 17 * x[1] + 17 * x[5] >= 26)
m.addConstr(4 * x[0] + 17 * x[1] + 12 * x[3] >= 35)
m.addConstr(17 * x[1] + 17 * x[4] + 17 * x[5] >= 35)
m.addConstr(4 * x[0] + 17 * x[1] + 17 * x[5] >= 35)
m.addConstr(4 * x[0] + 17 * x[1] + 12 * x[3] >= 30)
m.addConstr(17 * x[1] + 17 * x[4] + 17 * x[5] >= 30)
m.addConstr(4 * x[0] + 17 * x[1] + 17 * x[5] >= 30)
m.addConstr(x[1] - 8 * x[3] + 7 * x[4] >= 0)
m.addConstr(4 * x[0] + 17 * x[1] <= 134)
m.addConstr(4 * x[0] + 17 * x[5] <= 191)
m.addConstr(17 * x[1] + 17 * x[4] <= 43)
m.addConstr(17 * x[4] + 17 * x[5] <= 100)
m.addConstr(12 * x[3] + 17 * x[4] <= 216)
m.addConstr(17 * x[1] + 9 * x[2] <= 133)
m.addConstr(17 * x[1] + 9 * x[2] + 17 * x[4] <= 83)
m.addConstr(4 * x[0] + 9 * x[2] + 12 * x[3] <= 222)
m.addConstr(4 * x[0] + 17 * x[1] + 12 * x[3] <= 173)
m.addConstr(4 * x[0] + 17 * x[1] + 17 * x[5] <= 108)
m.addConstr(9 * x[2] + 17 * x[4] + 17 * x[5] <= 193)
m.addConstr(17 * x[1] + 9 * x[2] + 12 * x[3] <= 221)
m.addConstr(4 * x[0] + 17 * x[4] + 17 * x[5] <= 165)
m.addConstr(4 * x[0] + 9 * x[2] + 17 * x[4] <= 215)
m.addConstr(4 * x[0] + 12 * x[3] + 17 * x[5] <= 105)
m.addConstr(9 * x[2] + 12 * x[3] + 17 * x[4] <= 145)
m.addConstr(4 * x[0] + 12 * x[3] + 17 * x[4] <= 225)
m.addConstr(4 * x[0] + 17 * x[1] + 9 * x[2] <= 176)
m.addConstr(17 * x[1] + 17 * x[4] + 17 * x[5] <= 104)
m.addConstr(17 * x[1] + 12 * x[3] + 17 * x[4] <= 79)
m.addConstr(4 * x[0] + 17 * x[1] + 9 * x[2] + 12 * x[3] + 17 * x[4] + 17 * x[5] <= 79)


# Optimize model
m.optimize()

# Print results
if m.status == gp.GRB.OPTIMAL:
    for v in m.getVars():
        print(f"{v.varName}: {v.x}")
    print(f"Obj: {m.objVal}")
elif m.status == gp.GRB.INFEASIBLE:
    print("The model is infeasible.")
else:
    print(f"Optimization ended with status {m.status}")

