
import gurobi

# Define the model
model = gurobi.Model()

# Define the variables
x1 = model.addVar(name="wooden_pencils", vtype=gurobi.GRB.INTEGER)
x2 = model.addVar(name="postage_stamps", vtype=gurobi.GRB.INTEGER)
x3 = model.addVar(name="red_highlighters", vtype=gurobi.GRB.INTEGER)
x4 = model.addVar(name="scissors", vtype=gurobi.GRB.INTEGER)
x5 = model.addVar(name="headsets", vtype=gurobi.GRB.INTEGER)
x6 = model.addVar(name="usb_flash_drives", vtype=gurobi.GRB.INTEGER)

# Define the objective function
model.setObjective(7.25 * x1 + 1.62 * x2 + 9.82 * x3 + 2.87 * x4 + 7.61 * x5 + 4.6 * x6, gurobi.GRB.MAXIMIZE)

# Add constraints
model.addConstr(4 * x1 + 17 * x2 + 9 * x3 + 12 * x4 + 17 * x5 + 17 * x6 <= 248)
model.addConstr(12 * x4 + 17 * x6 >= 32)
model.addConstr(4 * x1 + 9 * x3 >= 16)
model.addConstr(12 * x4 + 17 * x5 >= 23)
model.addConstr(4 * x1 + 17 * x5 >= 27)
model.addConstr(4 * x1 + 12 * x4 >= 37)
model.addConstr(4 * x1 + 17 * x2 >= 26)
model.addConstr(17 * x2 + 17 * x5 >= 15)
model.addConstr(17 * x2 + 12 * x4 >= 40)
model.addConstr(17 * x2 + 9 * x3 >= 40)
model.addConstr(17 * x2 + 17 * x6 >= 37)
model.addConstr(4 * x1 + 17 * x2 + 12 * x4 >= 26)
model.addConstr(17 * x2 + 17 * x5 + 17 * x6 >= 26)
model.addConstr(4 * x1 + 17 * x2 + 17 * x6 >= 26)
model.addConstr(4 * x1 + 17 * x2 + 12 * x4 >= 35)
model.addConstr(17 * x2 + 17 * x5 + 17 * x6 >= 35)
model.addConstr(4 * x1 + 17 * x2 + 17 * x6 >= 35)
model.addConstr(4 * x1 + 17 * x2 + 12 * x4 >= 30)
model.addConstr(17 * x2 + 17 * x5 + 17 * x6 >= 30)
model.addConstr(4 * x1 + 17 * x2 + 17 * x6 >= 30)
model.addConstr(x2 - 8 * x4 + 7 * x5 >= 0)
model.addConstr(4 * x1 + 17 * x2 <= 134)
model.addConstr(4 * x1 + 17 * x6 <= 191)
model.addConstr(17 * x2 + 17 * x5 <= 43)
model.addConstr(17 * x5 + 17 * x6 <= 100)
model.addConstr(12 * x4 + 17 * x5 <= 216)
model.addConstr(17 * x2 + 9 * x3 <= 133)
model.addConstr(17 * x2 + 9 * x3 + 17 * x5 <= 83)
model.addConstr(4 * x1 + 9 * x3 + 12 * x4 <= 222)
model.addConstr(4 * x1 + 17 * x2 + 12 * x4 <= 173)
model.addConstr(4 * x1 + 17 * x2 + 17 * x6 <= 108)
model.addConstr(9 * x3 + 17 * x5 + 17 * x6 <= 193)
model.addConstr(17 * x2 + 9 * x3 + 12 * x4 <= 221)
model.addConstr(4 * x1 + 17 * x5 + 17 * x6 <= 165)
model.addConstr(4 * x1 + 9 * x3 + 17 * x5 <= 215)
model.addConstr(4 * x1 + 12 * x4 + 17 * x6 <= 105)
model.addConstr(9 * x3 + 12 * x4 + 17 * x5 <= 145)
model.addConstr(4 * x1 + 12 * x4 + 17 * x5 <= 225)
model.addConstr(4 * x1 + 17 * x2 + 9 * x3 <= 176)
model.addConstr(17 * x2 + 17 * x5 + 17 * x6 <= 104)
model.addConstr(17 * x2 + 12 * x4 + 17 * x5 <= 79)
model.addConstr(4 * x1 + 17 * x2 + 9 * x3 + 12 * x4 + 17 * x5 + 17 * x6 <= 79)

# Solve the model
model.optimize()

# Print the solution
if model.status == gurobi.GRB.OPTIMAL:
    print("Objective: ", model.objval)
    print("Wooden Pencils: ", x1.varValue)
    print("Postage Stamps: ", x2.varValue)
    print("Red Highlighters: ", x3.varValue)
    print("Scissors: ", x4.varValue)
    print("Headsets: ", x5.varValue)
    print("USB Flash Drives: ", x6.varValue)
else:
    print("The model is infeasible")
