
import gurobipy as gp

try:
    # Create a new model
    m = gp.Model("optimization_problem")

    # Create variables
    cornichons = m.addVar(vtype=gp.GRB.INTEGER, name="cornichons")
    peanutbutter_sandwiches = m.addVar(vtype=gp.GRB.INTEGER, name="peanutbutter_sandwiches")

    # Set objective function
    m.setObjective(4*cornichons**2 + 6*cornichons*peanutbutter_sandwiches + 3*peanutbutter_sandwiches**2 + 4*cornichons + 2*peanutbutter_sandwiches, gp.GRB.MAXIMIZE)

    # Add constraints
    m.addConstr(11*cornichons + 10*peanutbutter_sandwiches >= 22, "fat_lower_bound")
    m.addConstr(5*cornichons + 8*peanutbutter_sandwiches >= 21, "cost_lower_bound")
    m.addConstr(6*cornichons**2 - 3*peanutbutter_sandwiches**2 >= 0, "quadratic_constraint")
    m.addConstr(11*cornichons + 10*peanutbutter_sandwiches <= 62, "fat_upper_bound")  # Corrected constraint
    m.addConstr(5*cornichons + 8*peanutbutter_sandwiches <= 59, "cost_upper_bound")  # Corrected constraint


    # Optimize model
    m.optimize()

    # Print results
    if m.status == gp.GRB.OPTIMAL:
        print('Obj: %g' % m.objVal)
        print('cornichons:', cornichons.x)
        print('peanutbutter_sandwiches:', peanutbutter_sandwiches.x)
    elif m.status == gp.GRB.INFEASIBLE:
        print('Optimization problem is infeasible.')
    else:
        print('Optimization ended with status %d' % m.status)


except gp.GurobiError as e:
    print('Error code ' + str(e.errno) + ': ' + str(e))

except AttributeError:
    print('Encountered an attribute error')
