
from gurobipy import *

# Create a new model
m = Model("Optimization_Problem")

# Add variables
x0 = m.addVar(vtype=GRB.INTEGER, name="cornichons")
x1 = m.addVar(vtype=GRB.INTEGER, name="peanutbutter_sandwiches")

# Set the objective function
m.setObjective(4*x0**2 + 6*x0*x1 + 3*x1**2 + 4*x0 + 2*x1, GRB.MAXIMIZE)

# Add constraints
m.addConstr(11*x0 + 10*x1 >= 22, name="min_fat")
m.addConstr(5*x0 + 8*x1 >= 21, name="min_cost")
m.addConstr(6*x0**2 - 3*x1**2 >= 0, name="fat_constraint")
m.addConstr(11*x0 + 10*x1 <= 62, name="max_fat")
m.addConstr(5*x0 + 8*x1 <= 59, name="max_cost")

# Optimize model
m.optimize()

# Print solution
if m.status == GRB.OPTIMAL:
    print("Optimal solution found:")
    print(f"cornichons: {x0.x}")
    print(f"peanutbutter sandwiches: {x1.x}")
    print(f"Objective value: {m.objVal}")
else:
    print("No optimal solution found")
