
import gurobi

def solve_optimization_problem():
    model = gurobi.Model()
    
    # Define variables
    x1 = model.addVar(name="cornichons", vtype=gurobi.GRB.INTEGER)
    x2 = model.addVar(name="peanutbutter_sandwiches", vtype=gurobi.GRB.INTEGER)

    # Objective function
    model.setObjective(4*x1**2 + 6*x1*x2 + 3*x2**2 + 4*x1 + 2*x2, gurobi.GRB.MAXIMIZE)

    # Constraints
    model.addConstr(11*x1 + 10*x2 >= 22, name="fat_constraint")
    model.addConstr(5*x1 + 8*x2 >= 21, name="cost_constraint")
    model.addConstr(6*x1**2 - 3*x2**2 >= 0, name="nonlinear_constraint")
    model.addConstr(11*x1 + 10*x2 <= 62, name="fat_bound")
    model.addConstr(5*x1 + 8*x2 <= 59, name="cost_bound")

    # Solve the model
    model.optimize()

    if model.status == gurobi.GRB.OPTIMAL:
        print("Optimal solution found.")
        print(f"Cornichons: {x1.varValue}, Peanutbutter Sandwiches: {x2.varValue}")
    elif model.status == gurobi.GRB.INFEASIBLE:
        print("The model is infeasible.")
    else:
        print("The model has a non-optimal status.")

solve_optimization_problem()
