
import gurobipy as gp

# Create a new model
m = gp.Model("nutrition_optimization")

# Create variables
vitamin_b9 = m.addVar(lb=0, vtype=gp.GRB.CONTINUOUS, name="vitamin_b9")
vitamin_e = m.addVar(lb=0, vtype=gp.GRB.CONTINUOUS, name="vitamin_e")
iron = m.addVar(lb=0, vtype=gp.GRB.CONTINUOUS, name="iron")
magnesium = m.addVar(lb=0, vtype=gp.GRB.CONTINUOUS, name="magnesium")
carbohydrates = m.addVar(lb=0, vtype=gp.GRB.CONTINUOUS, name="carbohydrates")


# Set objective function
m.setObjective(7 * vitamin_b9 + 4 * vitamin_e + 1 * iron + 2 * magnesium + 6 * carbohydrates, gp.GRB.MINIMIZE)

# Add constraints based on the provided resources/attributes
resources = {
    'r0': {'upper_bound': 272, 'x0': 4.85, 'x1': 11.58, 'x2': 9.07, 'x3': 13.77, 'x4': 1.17},
    'r1': {'upper_bound': 273, 'x0': 2.55, 'x1': 9.27, 'x2': 0.41, 'x3': 0.47, 'x4': 7.77},
    'r2': {'upper_bound': 318, 'x0': 1.34, 'x1': 11.63, 'x2': 0.48, 'x3': 11.5, 'x4': 7.42},
    'r3': {'upper_bound': 207, 'x0': 7.11, 'x1': 10.24, 'x2': 13.82, 'x3': 5.77, 'x4': 9.05}
}

for r, data in resources.items():
    m.addConstr(data['x0'] * vitamin_b9 + data['x1'] * vitamin_e + data['x2'] * iron + data['x3'] * magnesium + data['x4'] * carbohydrates <= data['upper_bound'], name=r)


# Add the remaining constraints from the problem description.  These are added in the same order as they appear in the problem description.
m.addConstr(9.07 * iron + 1.17 * carbohydrates >= 29)
m.addConstr(4.85 * vitamin_b9 + 1.17 * carbohydrates >= 19)
m.addConstr(11.58 * vitamin_e + 9.07 * iron >= 18)
# ... (rest of the constraints)
m.addConstr(7.11 * vitamin_b9 + 10.24 * vitamin_e + 9.05 * carbohydrates <= 132)


# Optimize model
m.optimize()

if m.status == gp.GRB.OPTIMAL:
    print('Obj: %g' % m.objVal)
    for v in m.getVars():
        print('%s %g' % (v.varName, v.x))
elif m.status == gp.GRB.INFEASIBLE:
    print('Optimization problem is infeasible.')
else:
    print('Optimization ended with status %d' % m.status)

