
import gurobipy as gp
from gurobipy import GRB

# Create a new model
model = gp.Model("Minimize Cost")

# Create variables
mary_hours = model.addVar(lb=0, vtype=GRB.CONTINUOUS, name="Mary_hours")  # Continuous variable
ringo_hours = model.addVar(lb=0, vtype=GRB.CONTINUOUS, name="Ringo_hours") # Continuous variable


# Set objective function
model.setObjective(7 * mary_hours + 3 * ringo_hours, GRB.MINIMIZE)

# Add constraints
model.addConstr(17 * mary_hours + 14 * ringo_hours >= 36, "dollar_cost_min")
model.addConstr(17 * mary_hours + 14 * ringo_hours == 36, "dollar_cost_eq") # Redundant, but included as per problem description
model.addConstr(8 * mary_hours + 8 * ringo_hours >= 35, "org_score_min")
model.addConstr(-6 * mary_hours + 5 * ringo_hours >= 0, "combined_hours")
model.addConstr(17 * mary_hours + 14 * ringo_hours <= 60, "dollar_cost_max")
model.addConstr(8 * mary_hours + 8 * ringo_hours <= 93, "org_score_max")


# Optimize model
model.optimize()

# Check for infeasibility
if model.status == GRB.INFEASIBLE:
    print("The model is infeasible.")
    # Compute and print IIS (Irreducible Inconsistent Subsystem)
    model.computeIIS()
    model.write("model_iis.ilp") # Write the IIS to a file for inspection
    print("See model_iis.ilp for the IIS.")
else:
    # Print solution
    print("Optimal Solution:")
    print(f"Mary's hours: {mary_hours.x}")
    print(f"Ringo's hours: {ringo_hours.x}")
    print(f"Objective Value: {model.objVal}")

