
from gurobipy import *

# Create a new model
m = Model("Optimization_Problem")

# Define the variables
x1 = m.addVar(lb=0, name="hours_worked_by_Mary")
x2 = m.addVar(lb=0, name="hours_worked_by_Ringo")

# Set the objective function
m.setObjective(7*x1 + 3*x2, GRB.MINIMIZE)

# Add constraints
m.addConstr(17*x1 + 14*x2 >= 36, name="dollar_cost_constraint")
m.addConstr(8*x1 + 8*x2 >= 35, name="organization_score_min_constraint")
m.addConstr(-6*x1 + 5*x2 >= 0, name="mixed_hours_constraint")
m.addConstr(17*x1 + 14*x2 <= 60, name="dollar_cost_max_constraint")
m.addConstr(8*x1 + 8*x2 <= 93, name="organization_score_max_constraint")

# Optimize the model
m.optimize()

# Print the results
if m.status == GRB.OPTIMAL:
    print("Optimal solution found:")
    print(f"Hours worked by Mary: {x1.x}")
    print(f"Hours worked by Ringo: {x2.x}")
    print(f"Objective function value: {m.objVal}")
else:
    print("No optimal solution found")
