
import gurobi

def solve_optimization_problem():
    # Create a new model
    model = gurobi.Model()

    # Define the variables
    x1 = model.addVar(name="hours_worked_by_Mary", lb=0)  # Assuming non-negative hours
    x2 = model.addVar(name="hours_worked_by_Ringo", lb=0)  # Assuming non-negative hours

    # Set the objective function
    model.setObjective(7 * x1 + 3 * x2, gurobi.GRB.MINIMIZE)

    # Add constraints
    model.addConstr(17 * x1 + 14 * x2 >= 36)
    model.addConstr(17 * x1 + 14 * x2 <= 60)
    model.addConstr(8 * x1 + 8 * x2 >= 35)
    model.addConstr(8 * x1 + 8 * x2 <= 93)
    model.addConstr(-6 * x1 + 5 * x2 >= 0)

    # Optimize the model
    model.optimize()

    # Print the status
    if model.status == gurobi.GRB.Status.OPTIMAL:
        print("Optimal solution found.")
        print(f"Hours worked by Mary: {x1.x}")
        print(f"Hours worked by Ringo: {x2.x}")
        print(f"Objective function value: {model.objVal}")
    elif model.status == gurobi.GRB.Status.INFEASIBLE:
        print("No feasible solution exists.")
    else:
        print("No optimal solution could be found.")

solve_optimization_problem()
