
import gurobipy as gp

# Create a new model
m = gp.Model("diet_optimization")

# Create variables
kale_salads = m.addVar(lb=0, vtype=gp.GRB.CONTINUOUS, name="kale_salads")
bowls_of_cereal = m.addVar(lb=0, vtype=gp.GRB.CONTINUOUS, name="bowls_of_cereal")
sashimi = m.addVar(lb=0, vtype=gp.GRB.INTEGER, name="sashimi")


# Set objective function
m.setObjective(1.45 * kale_salads + 2.92 * bowls_of_cereal + 6.97 * sashimi, gp.GRB.MINIMIZE)

# Add constraints
m.addConstr(10 * kale_salads + 1 * bowls_of_cereal + 13 * sashimi <= 127, "fat_ub")
m.addConstr(1 * kale_salads + 5 * bowls_of_cereal + 7 * sashimi <= 77, "carbs_ub")
m.addConstr(12 * kale_salads + 5 * bowls_of_cereal + 12 * sashimi <= 73, "fiber_ub")
m.addConstr(14 * kale_salads + 10 * bowls_of_cereal + 4 * sashimi <= 81, "protein_ub")

m.addConstr(10 * kale_salads + 1 * bowls_of_cereal >= 28, "fat_ks_bc_lb")
m.addConstr(1 * bowls_of_cereal + 13 * sashimi >= 38, "fat_bc_s_lb")
m.addConstr(10 * kale_salads + 13 * sashimi >= 21, "fat_ks_s_lb")
m.addConstr(10 * kale_salads + 1 * bowls_of_cereal + 13 * sashimi >= 21, "fat_all_lb")

m.addConstr(1 * kale_salads + 5 * bowls_of_cereal >= 11, "carbs_ks_bc_lb")
m.addConstr(1 * kale_salads + 7 * sashimi >= 14, "carbs_ks_s_lb")
m.addConstr(1 * kale_salads + 5 * bowls_of_cereal + 7 * sashimi >= 14, "carbs_all_lb")


m.addConstr(12 * kale_salads + 5 * bowls_of_cereal >= 9, "fiber_ks_bc_lb")
m.addConstr(12 * kale_salads + 5 * bowls_of_cereal + 12 * sashimi >= 9, "fiber_all_lb")

m.addConstr(10 * bowls_of_cereal + 4 * sashimi >= 26, "protein_bc_s_lb")
m.addConstr(14 * kale_salads + 10 * bowls_of_cereal >= 14, "protein_ks_bc_lb")
m.addConstr(14 * kale_salads + 10 * bowls_of_cereal + 4 * sashimi >= 14, "protein_all_lb")

m.addConstr(9 * bowls_of_cereal - 4 * sashimi >= 0, "cereal_sashimi_relation")
m.addConstr(1 * kale_salads + 5 * bowls_of_cereal + 7 * sashimi <= 54, "carbs_all_ub")
m.addConstr(14 * kale_salads + 4 * sashimi <= 49, "protein_ks_s_ub")


# Optimize model
m.optimize()

# Print solution
if m.status == gp.GRB.OPTIMAL:
    print('Obj: %g' % m.objVal)
    print('kale_salads:', kale_salads.x)
    print('bowls_of_cereal:', bowls_of_cereal.x)
    print('sashimi:', sashimi.x)
elif m.status == gp.GRB.INFEASIBLE:
    print('The model is infeasible.')
else:
    print('Optimization ended with status %d' % m.status)

