
from gurobipy import *

# Create a new model
m = Model("Optimization_Problem")

# Create variables
x0 = m.addVar(lb=0, name="kale_salads", vtype=GRB.CONTINUOUS)
x1 = m.addVar(lb=0, name="bowls_of_cereal", vtype=GRB.CONTINUOUS)
x2 = m.addVar(lb=0, name="sashimi", vtype=GRB.INTEGER)

# Objective function
m.setObjective(1.45*x0 + 2.92*x1 + 6.97*x2, GRB.MINIMIZE)

# Constraints
m.addConstr(10*x0 + x1 + 13*x2 >= 28)
m.addConstr(x1 + 13*x2 >= 38)
m.addConstr(10*x0 + 13*x2 >= 21)
m.addConstr(10*x0 + x1 + 13*x2 >= 21)
m.addConstr(x0 + 5*x1 >= 11)
m.addConstr(x0 + 7*x2 >= 14)
m.addConstr(x0 + 5*x1 + 7*x2 <= 54)
m.addConstr(x0 + 5*x1 + 7*x2 >= 14)
m.addConstr(12*x0 + 5*x1 >= 9)
m.addConstr(12*x0 + 5*x1 + 12*x2 >= 9)
m.addConstr(10*x1 + 4*x2 >= 26)
m.addConstr(14*x0 + 10*x1 >= 14)
m.addConstr(14*x0 + 10*x1 + 4*x2 >= 14)
m.addConstr(9*x1 - 4*x2 >= 0)
m.addConstr(14*x0 + 4*x2 <= 49)

# Optimize model
m.optimize()

# Print results
if m.status == GRB.OPTIMAL:
    print("Optimal solution found:")
    print(f'kale_salads: {x0.x}, bowls_of_cereal: {x1.x}, sashimi: {x2.x}')
    print(f"Objective function value: {m.objVal}")
else:
    print("No optimal solution found")
