
import gurobi

# Define the model
model = gurobi.Model()

# Define the variables
x0 = model.addVar(name='kale_salads', lb=0, ub=None)
x1 = model.addVar(name='bowls_of_cereal', lb=0, ub=None)
x2 = model.addVar(name='sashimi', lb=0, ub=None, integrality=gurobi.GRB.INTEGER)

# Set the objective function
model.setObjective(1.45*x0 + 2.92*x1 + 6.97*x2, gurobi.GRB.MINIMIZE)

# Add constraints
model.addConstr(10*x0 + 1*x1 + 13*x2 <= 127, name='fat')
model.addConstr(1*x0 + 5*x1 + 7*x2 <= 77, name='carbohydrates')
model.addConstr(12*x0 + 5*x1 + 12*x2 <= 73, name='fiber')
model.addConstr(14*x0 + 10*x1 + 4*x2 <= 81, name='protein')
model.addConstr(10*x0 + 1*x1 >= 28, name='fat_kale_cereal')
model.addConstr(1*x1 + 13*x2 >= 38, name='fat_cereal_sashimi')
model.addConstr(10*x0 + 13*x2 >= 21, name='fat_kale_sashimi')
model.addConstr(10*x0 + 1*x1 + 13*x2 >= 21, name='fat_all')
model.addConstr(1*x0 + 5*x1 >= 11, name='carbohydrates_kale_cereal')
model.addConstr(1*x0 + 7*x2 >= 14, name='carbohydrates_kale_sashimi')
model.addConstr(1*x0 + 5*x1 + 7*x2 >= 14, name='carbohydrates_all')
model.addConstr(12*x0 + 5*x1 >= 9, name='fiber_kale_cereal')
model.addConstr(12*x0 + 5*x1 + 12*x2 >= 9, name='fiber_all')
model.addConstr(10*x1 + 4*x2 >= 26, name='protein_cereal_sashimi')
model.addConstr(14*x0 + 10*x1 >= 14, name='protein_kale_cereal')
model.addConstr(14*x0 + 10*x1 + 4*x2 >= 14, name='protein_all')
model.addConstr(9*x1 - 4*x2 >= 0, name='cereal_sashimi')
model.addConstr(1*x0 + 5*x1 + 7*x2 <= 54, name='carbohydrates_limit')
model.addConstr(14*x0 + 4*x2 <= 49, name='protein_kale_sashimi')

# Optimize the model
model.optimize()

# Print the solution
if model.status == gurobi.GRB.OPTIMAL:
    print('Objective: ', model.objVal)
    print('Kale Salads: ', x0.varValue)
    print('Bowls of Cereal: ', x1.varValue)
    print('Sashimi: ', x2.varValue)
else:
    print('The model is infeasible')
