
import gurobipy as gp

# Create a new model
m = gp.Model("food_optimization")

# Create variables
kiwis = m.addVar(vtype=gp.GRB.INTEGER, name="kiwis")
chicken_breasts = m.addVar(vtype=gp.GRB.INTEGER, name="chicken_breasts")
corn_cobs = m.addVar(vtype=gp.GRB.CONTINUOUS, name="corn_cobs")
slices_of_pizza = m.addVar(vtype=gp.GRB.CONTINUOUS, name="slices_of_pizza")


# Set objective function
m.setObjective(8.29 * kiwis + 4.0 * chicken_breasts + 5.7 * corn_cobs + 4.93 * slices_of_pizza, gp.GRB.MINIMIZE)

# Add constraints
m.addConstr(3.64 * kiwis + 4.34 * chicken_breasts + 2.6 * corn_cobs + 2.76 * slices_of_pizza <= 121, "r0")
m.addConstr(2.36 * kiwis + 3.37 * chicken_breasts + 1.36 * corn_cobs + 2.06 * slices_of_pizza <= 95, "r1")
m.addConstr(4.56 * kiwis + 4.47 * chicken_breasts + 3.69 * corn_cobs + 3.69 * slices_of_pizza <= 142, "r2")
m.addConstr(4.15 * kiwis + 3.67 * chicken_breasts + 3.23 * corn_cobs + 4.61 * slices_of_pizza <= 167, "r3")

m.addConstr(4.34 * chicken_breasts + 2.76 * slices_of_pizza >= 14, "c1")
m.addConstr(4.34 * chicken_breasts + 2.6 * corn_cobs >= 18, "c2")
m.addConstr(3.64 * kiwis + 4.34 * chicken_breasts + 2.76 * slices_of_pizza >= 20, "c3")
m.addConstr(3.64 * kiwis + 4.34 * chicken_breasts + 2.6 * corn_cobs >= 20, "c4")
m.addConstr(3.64 * kiwis + 4.34 * chicken_breasts + 2.76 * slices_of_pizza >= 25, "c5")
m.addConstr(3.64 * kiwis + 4.34 * chicken_breasts + 2.6 * corn_cobs >= 25, "c6")
m.addConstr(3.64 * kiwis + 4.34 * chicken_breasts + 2.6 * corn_cobs + 2.76 * slices_of_pizza >= 25, "c7")


# ... (rest of the constraints)

m.optimize()

if m.status == gp.GRB.OPTIMAL:
    print('Obj: %g' % m.objVal)
    for v in m.getVars():
        print('%s %g' % (v.varName, v.x))
elif m.status == gp.GRB.INFEASIBLE:
    print("The model is infeasible.")
else:
    print("Optimization ended with status %d" % m.status)

