
import gurobipy as gp
from gurobipy import GRB

try:
    # Create a new model
    model = gp.Model("optimization_problem")

    # Create variables
    x0 = model.addVar(vtype=GRB.INTEGER, name="x0") # hours worked by Mary
    x1 = model.addVar(vtype=GRB.INTEGER, name="x1") # hours worked by George
    x2 = model.addVar(vtype=GRB.CONTINUOUS, name="x2") # hours worked by Paul


    # Set objective function
    obj = 1.6*x0**2 + 2.23*x0*x1 + 5.54*x0*x2 + 6.78*x1**2 + 7.89*x1*x2 + 6.63*x2**2 + 8.77*x0 + 1.15*x2
    model.setObjective(obj, GRB.MINIMIZE)

    # Add constraints
    model.addConstr(5*x0 + 8*x1 >= 20, "c0")
    model.addConstr(5*x0**2 + 12*x2**2 >= 27, "c1")
    model.addConstr(8*x1 + 12*x2 >= 15, "c2")
    model.addConstr(5*x0 + 8*x1 + 12*x2 >= 15, "c3")
    model.addConstr(13*x1**2 + 10*x2**2 >= 8, "c4")
    model.addConstr(10*x0 + 10*x2 >= 26, "c5")
    model.addConstr(10*x0 + 13*x1 + 10*x2 >= 13, "c6")
    model.addConstr(-x1**2 + 4*x2**2 >= 0, "c7")
    model.addConstr(5*x0 + 12*x2 <= 85, "c8")
    model.addConstr(5*x0 + 8*x1 <= 85, "c9")
    model.addConstr(5*x0 + 8*x1 + 12*x2 <= 79, "c10")
    model.addConstr(10*x0**2 + 13*x1**2 <= 47, "c11")


    # Optimize model
    model.optimize()

    if model.status == GRB.OPTIMAL:
        print('Obj: %g' % model.objVal)
        for v in model.getVars():
            print('%s %g' % (v.varName, v.x))
    elif model.status == GRB.INFEASIBLE:
        print('Model is infeasible')
    else:
        print('Optimization ended with status %d' % model.status)



except gp.GurobiError as e:
    print('Error code ' + str(e.errno) + ': ' + str(e))

except AttributeError:
    print('Encountered an attribute error')
