
import gurobi

# Create a new model
m = gurobi.Model()

# Define variables
x0 = m.addVar(name="x0", lb=0, type=gurobi.GRB.INTEGER)  # hours worked by Mary
x1 = m.addVar(name="x1", lb=0, type=gurobi.GRB.INTEGER)  # hours worked by George
x2 = m.addVar(name="x2", lb=0)  # hours worked by Paul

# Objective function
m.setObjective(1.6*x0**2 + 2.23*x0*x1 + 5.54*x0*x2 + 6.78*x1**2 + 7.89*x1*x2 + 6.63*x2**2 + 8.77*x0 + 1.15*x2, gurobi.GRB.MINIMIZE)

# Constraints
m.addConstr(5 * x0 <= 113, name="Mary_productivity")
m.addConstr(10 * x0 <= 78, name="Mary_paperwork")
m.addConstr(8 * x1 <= 113, name="George_productivity")
m.addConstr(13 * x1 <= 78, name="George_paperwork")
m.addConstr(12 * x2 <= 113, name="Paul_productivity")
m.addConstr(10 * x2 <= 78, name="Paul_paperwork")

m.addConstr(5 * x0 + 8 * x1 >= 20, name="Mary_George_productivity")
m.addConstr(25 * x0**2 + 144 * x2**2 >= 27, name="Mary_Paul_productivity_squared")
m.addConstr(8 * x1 + 12 * x2 >= 15, name="George_Paul_productivity")
m.addConstr(5 * x0 + 8 * x1 + 12 * x2 >= 15, name="all_productivity")

m.addConstr(169 * x1**2 + 100 * x2**2 >= 8, name="George_Paul_paperwork_squared")
m.addConstr(10 * x0 + 10 * x2 >= 26, name="Mary_Paul_paperwork")
m.addConstr(10 * x0 + 13 * x1 + 10 * x2 >= 13, name="all_paperwork")

m.addConstr(-x1**2 + 4 * x2**2 >= 0, name="George_Paul_work")
m.addConstr(5 * x0 + 12 * x2 <= 85, name="Mary_Paul_productivity_limit")
m.addConstr(5 * x0 + 8 * x1 <= 85, name="Mary_George_productivity_limit")
m.addConstr(5 * x0 + 8 * x1 + 12 * x2 <= 79, name="all_productivity_limit")
m.addConstr(100 * x0**2 + 169 * x1**2 <= 47, name="Mary_George_paperwork_squared")

# Solve the model
m.optimize()

# Print the solution
if m.status == gurobi.GRB.OPTIMAL:
    print("Objective: ", m.objVal)
    print("x0: ", x0.varValue)
    print("x1: ", x1.varValue)
    print("x2: ", x2.varValue)
else:
    print("The model is infeasible")
