
import gurobipy as gp

# Create a new model
model = gp.Model("FoodOptimization")

# Create variables
ravioli = model.addVar(vtype=gp.GRB.INTEGER, name="ravioli")
cheeseburgers = model.addVar(vtype=gp.GRB.INTEGER, name="cheeseburgers")
steaks = model.addVar(vtype=gp.GRB.CONTINUOUS, name="steaks")
bagged_salads = model.addVar(vtype=gp.GRB.INTEGER, name="bagged_salads")
hamburgers = model.addVar(vtype=gp.GRB.INTEGER, name="hamburgers")

# Set objective function
model.setObjective(3.66 * ravioli + 5.55 * cheeseburgers + 2.59 * steaks + 4.16 * bagged_salads + 8.57 * hamburgers, gp.GRB.MINIMIZE)

# Add constraints
model.addConstr(18 * ravioli + 7 * hamburgers >= 20, "tastiness_ravioli_hamburgers_min")
model.addConstr(18 * ravioli + 18 * bagged_salads >= 6, "tastiness_ravioli_bagged_salads_min")
model.addConstr(17 * steaks + 18 * bagged_salads >= 19, "tastiness_steaks_bagged_salads_min")
model.addConstr(17 * steaks + 18 * bagged_salads + 7 * hamburgers >= 20, "tastiness_steaks_bagged_salads_hamburgers_min")
model.addConstr(18 * ravioli + 3 * cheeseburgers + 17 * steaks + 18 * bagged_salads + 7 * hamburgers >= 20, "tastiness_total_min")
model.addConstr(4 * steaks - 9 * bagged_salads >= 0, "steaks_bagged_salads_relation")
model.addConstr(-4 * cheeseburgers + 3 * steaks >= 0, "cheeseburgers_steaks_relation")
model.addConstr(18 * ravioli + 7 * hamburgers <= 38, "tastiness_ravioli_hamburgers_max")
model.addConstr(3 * cheeseburgers + 7 * hamburgers <= 91, "tastiness_cheeseburgers_hamburgers_max")
model.addConstr(18 * ravioli + 3 * cheeseburgers + 17 * steaks <= 34, "tastiness_ravioli_cheeseburgers_steaks_max")


# Optimize model
model.optimize()

# Print results
if model.status == gp.GRB.OPTIMAL:
    print("Optimal solution found:")
    print("Ravioli:", ravioli.x)
    print("Cheeseburgers:", cheeseburgers.x)
    print("Steaks:", steaks.x)
    print("Bagged Salads:", bagged_salads.x)
    print("Hamburgers:", hamburgers.x)
    print("Objective Value:", model.objVal)
elif model.status == gp.GRB.INFEASIBLE:
    print("Model is infeasible.")
else:
    print("Optimization terminated with status:", model.status)

