
import gurobi

# Create a new model
model = gurobi.Model()

# Define the variables
x1 = model.addVar(name="ravioli", vtype=gurobi.GRB.INTEGER)  # integer
x2 = model.addVar(name="cheeseburgers", vtype=gurobi.GRB.INTEGER)  # integer
x3 = model.addVar(name="steaks", vtype=gurobi.GRB.CONTINUOUS)  # continuous
x4 = model.addVar(name="bagged_salads", vtype=gurobi.GRB.INTEGER)  # integer
x5 = model.addVar(name="hamburgers", vtype=gurobi.GRB.INTEGER)  # integer

# Set the objective function
model.setObjective(3.66 * x1 + 5.55 * x2 + 2.59 * x3 + 4.16 * x4 + 8.57 * x5, gurobi.GRB.MINIMIZE)

# Add constraints
model.addConstr(18 * x1 + 7 * x5 >= 20)
model.addConstr(18 * x1 + 18 * x4 >= 6)
model.addConstr(17 * x3 + 18 * x4 >= 19)
model.addConstr(17 * x3 + 18 * x4 + 7 * x5 >= 20)
model.addConstr(18 * x1 + 3 * x2 + 17 * x3 + 18 * x4 + 7 * x5 >= 20)
model.addConstr(4 * x3 - 9 * x4 >= 0)
model.addConstr(-4 * x2 + 3 * x3 >= 0)
model.addConstr(18 * x1 + 7 * x5 <= 38)
model.addConstr(3 * x2 + 7 * x5 <= 91)
model.addConstr(18 * x1 + 3 * x2 + 17 * x3 <= 34)

# Optimize the model
model.optimize()

# Print the solution
if model.status == gurobi.GRB.OPTIMAL:
    print("Objective: ", model.objval)
    print("Ravioli: ", x1.varValue)
    print("Cheeseburgers: ", x2.varValue)
    print("Steaks: ", x3.varValue)
    print("Bagged Salads: ", x4.varValue)
    print("Hamburgers: ", x5.varValue)
else:
    print("The model is infeasible")
