
import gurobipy as gp

# Create a new model
m = gp.Model("food_optimization")

# Create variables
ham_sandwiches = m.addVar(lb=0, vtype=gp.GRB.CONTINUOUS, name="ham_sandwiches")
rotisserie_chickens = m.addVar(lb=0, vtype=gp.GRB.CONTINUOUS, name="rotisserie_chickens")
peanutbutter_sandwiches = m.addVar(lb=0, vtype=gp.GRB.CONTINUOUS, name="peanutbutter_sandwiches")


# Set objective function
m.setObjective(1.84 * ham_sandwiches + 1.46 * rotisserie_chickens + 8.82 * peanutbutter_sandwiches, gp.GRB.MINIMIZE)

# Add constraints
m.addConstr(3.95 * ham_sandwiches + 1.0 * peanutbutter_sandwiches >= 20, "iron_constraint1")
m.addConstr(3.95 * ham_sandwiches + 0.36 * rotisserie_chickens + 1.0 * peanutbutter_sandwiches >= 20, "iron_constraint2")
m.addConstr(5.08 * ham_sandwiches + 0.37 * peanutbutter_sandwiches >= 63, "umami_constraint1")
m.addConstr(5.67 * rotisserie_chickens + 0.37 * peanutbutter_sandwiches >= 61, "umami_constraint2")
m.addConstr(5.08 * ham_sandwiches + 5.67 * rotisserie_chickens + 0.37 * peanutbutter_sandwiches >= 69, "umami_constraint3")
m.addConstr(-10 * rotisserie_chickens + 8 * peanutbutter_sandwiches >= 0, "misc_constraint1")

# Resource Constraints
m.addConstr(3.95 * ham_sandwiches + 0.36 * rotisserie_chickens + 1.0 * peanutbutter_sandwiches <= 151, "iron_resource_constraint")
m.addConstr(5.08 * ham_sandwiches + 5.67 * rotisserie_chickens + 0.37 * peanutbutter_sandwiches <= 212, "umami_resource_constraint")


# Optimize model
m.optimize()

# Print results
if m.status == gp.GRB.OPTIMAL:
    print('Obj: %g' % m.objVal)
    print('ham_sandwiches:', ham_sandwiches.x)
    print('rotisserie_chickens:', rotisserie_chickens.x)
    print('peanutbutter_sandwiches:', peanutbutter_sandwiches.x)
elif m.status == gp.GRB.INFEASIBLE:
    print('The model is infeasible.')
else:
    print('Optimization ended with status %d' % m.status)

