
import gurobi

def solve_optimization_problem():
    # Create a new model
    model = gurobi.Model()

    # Define the variables
    x0 = model.addVar(name="ham_sandwiches", lb=0)  # ham sandwiches
    x1 = model.addVar(name="rotisserie_chickens", lb=0)  # rotisserie chickens
    x2 = model.addVar(name="peanutbutter_sandwiches", lb=0)  # peanutbutter sandwiches

    # Define the objective function
    model.setObjective(1.84 * x0 + 1.46 * x1 + 8.82 * x2, gurobi.GRB.MINIMIZE)

    # Add constraints
    model.addConstr(3.95 * x0 + 1.0 * x2 >= 20)  # at least 20 milligrams of iron from ham sandwiches and peanutbutter sandwiches
    model.addConstr(3.95 * x0 + 0.36 * x1 + 1.0 * x2 >= 20)  # at least 20 milligrams of iron from all sources
    model.addConstr(5.08 * x0 + 0.37 * x2 >= 63)  # umami index from ham sandwiches and peanutbutter sandwiches
    model.addConstr(5.67 * x1 + 0.37 * x2 >= 61)  # umami index from rotisserie chickens and peanutbutter sandwiches
    model.addConstr(5.08 * x0 + 5.67 * x1 + 0.37 * x2 >= 69)  # umami index from all sources
    model.addConstr(-10 * x1 + 8 * x2 >= 0)  # rotisserie chickens and peanutbutter sandwiches constraint

    # Optimize the model
    model.optimize()

    # Print the solution
    if model.status == gurobi.GRB.OPTIMAL:
        print("Optimal solution found.")
        print(f"Ham sandwiches: {x0.varValue}")
        print(f"Rotisserie chickens: {x1.varValue}")
        print(f"Peanutbutter sandwiches: {x2.varValue}")
        print(f"Objective function value: {model.objVal}")
    else:
        print("No optimal solution found.")

solve_optimization_problem()
