
import gurobipy as gp

# Create a new model
m = gp.Model("optimization_problem")

# Create variables
strawberries = m.addVar(lb=0, vtype=gp.GRB.CONTINUOUS, name="strawberries")
protein_bars = m.addVar(lb=0, vtype=gp.GRB.CONTINUOUS, name="protein_bars")
chicken_breasts = m.addVar(lb=0, vtype=gp.GRB.CONTINUOUS, name="chicken_breasts")

# Set objective function
m.setObjective(4.14 * strawberries + 4.67 * protein_bars + 6.65 * chicken_breasts, gp.GRB.MINIMIZE)

# Add constraints
m.addConstr(22 * strawberries + 4 * protein_bars >= 75, "c1")
m.addConstr(22 * strawberries + 7 * chicken_breasts >= 38, "c2")
m.addConstr(4 * protein_bars + 7 * chicken_breasts >= 38, "c3")
m.addConstr(22 * strawberries + 4 * protein_bars + 7 * chicken_breasts >= 38, "c4")
m.addConstr(20 * strawberries + 18 * protein_bars >= 61, "c5")
m.addConstr(20 * strawberries + 2 * chicken_breasts >= 42, "c6")
m.addConstr(18 * protein_bars + 2 * chicken_breasts >= 42, "c7")
m.addConstr(20 * strawberries + 18 * protein_bars + 2 * chicken_breasts >= 42, "c8")
m.addConstr(7 * strawberries - 8 * chicken_breasts >= 0, "c9")
m.addConstr(3 * protein_bars - 9 * chicken_breasts >= 0, "c10")
m.addConstr(22 * strawberries + 7 * chicken_breasts <= 194, "c11")
m.addConstr(22 * strawberries + 4 * protein_bars + 7 * chicken_breasts <= 140, "c12")


# Resource Constraints
m.addConstr(22 * strawberries + 4 * protein_bars + 7 * chicken_breasts <= 318, "tastiness_limit")
m.addConstr(20 * strawberries + 18 * protein_bars + 2 * chicken_breasts <= 195, "carbohydrate_limit")


# Optimize model
m.optimize()

# Print results
if m.status == gp.GRB.OPTIMAL:
    print('Obj: %g' % m.objVal)
    for v in m.getVars():
        print('%s %g' % (v.varName, v.x))
elif m.status == gp.GRB.INFEASIBLE:
    print("The model is infeasible.")
else:
    print("Optimization ended with status %d" % m.status)

