
import gurobi

# Create a new model
model = gurobi.Model()

# Define the variables
x0 = model.addVar(name="strawberries", lb=0)
x1 = model.addVar(name="protein_bars", lb=0)
x2 = model.addVar(name="chicken_breasts", lb=0)

# Objective function
model.setObjective(4.14 * x0 + 4.67 * x1 + 6.65 * x2, gurobi.GRB.MINIMIZE)

# Constraints
model.addConstr(22 * x0 + 4 * x1 >= 75, name="strawberries_protein_bars_tastiness")
model.addConstr(22 * x0 + 7 * x2 >= 38, name="strawberries_chicken_breasts_tastiness")
model.addConstr(4 * x1 + 7 * x2 >= 38, name="protein_bars_chicken_breasts_tastiness")
model.addConstr(22 * x0 + 4 * x1 + 7 * x2 >= 38, name="all_tastiness")

model.addConstr(20 * x0 + 18 * x1 >= 61, name="strawberries_protein_bars_carbohydrates")
model.addConstr(20 * x0 + 2 * x2 >= 42, name="strawberries_chicken_breasts_carbohydrates")
model.addConstr(18 * x1 + 2 * x2 >= 42, name="protein_bars_chicken_breasts_carbohydrates")
model.addConstr(20 * x0 + 18 * x1 + 2 * x2 >= 42, name="all_carbohydrates")

model.addConstr(7 * x0 - 8 * x2 >= 0, name="strawberries_chicken_breasts_relationship")
model.addConstr(3 * x1 - 9 * x2 >= 0, name="protein_bars_chicken_breasts_relationship")

model.addConstr(22 * x0 + 7 * x2 <= 194, name="strawberries_chicken_breasts_max_tastiness")
model.addConstr(22 * x0 + 4 * x1 + 7 * x2 <= 140, name="all_max_tastiness")

# Optimize the model
model.optimize()

# Print the solution
if model.status == gurobi.GRB.OPTIMAL:
    print("Objective: ", model.objVal)
    print("Strawberries: ", x0.varValue)
    print("Protein Bars: ", x1.varValue)
    print("Chicken Breasts: ", x2.varValue)
else:
    print("The model is infeasible")
