
import gurobipy as gp

# Create a new model
model = gp.Model("optimization_problem")

# Create variables
fruit_salads = model.addVar(lb=0, vtype=gp.GRB.CONTINUOUS, name="fruit_salads")
protein_bars = model.addVar(lb=0, vtype=gp.GRB.CONTINUOUS, name="protein_bars")
lemons = model.addVar(lb=0, vtype=gp.GRB.CONTINUOUS, name="lemons")

# Set objective function
model.setObjective(9.34 * fruit_salads + 4.2 * protein_bars + 4.27 * lemons, gp.GRB.MAXIMIZE)

# Add constraints
model.addConstr(6 * fruit_salads + 6 * protein_bars + 7 * lemons >= 26, "c0")
model.addConstr(18 * fruit_salads + 18 * protein_bars + 20 * lemons >= 29, "c1")
model.addConstr(6 * fruit_salads + 6 * protein_bars <= 64, "c2")
model.addConstr(6 * fruit_salads + 7 * lemons <= 98, "c3")
model.addConstr(6 * fruit_salads + 6 * protein_bars + 7 * lemons <= 98, "c4")
model.addConstr(18 * fruit_salads + 18 * protein_bars <= 60, "c5")
model.addConstr(18 * fruit_salads + 20 * lemons <= 46, "c6")
model.addConstr(18 * fruit_salads + 18 * protein_bars + 20 * lemons <= 46, "c7")
model.addConstr(9 * fruit_salads + 17 * protein_bars <= 155, "c8")
model.addConstr(9 * fruit_salads + 8 * lemons <= 192, "c9")
model.addConstr(9 * fruit_salads + 17 * protein_bars + 8 * lemons <= 192, "c10")


# Optimize model
model.optimize()

# Print results
if model.status == gp.GRB.OPTIMAL:
    print(f"Optimal objective value: {model.objVal}")
    print(f"Fruit Salads: {fruit_salads.x}")
    print(f"Protein Bars: {protein_bars.x}")
    print(f"Lemons: {lemons.x}")
elif model.status == gp.GRB.INFEASIBLE:
    print("The model is infeasible.")
else:
    print(f"Optimization ended with status {model.status}")

