
import gurobi

def solve_optimization_problem():
    # Create a new model
    model = gurobi.Model()

    # Define the variables
    x0 = model.addVar(name="fruit_salads", lb=0)  # No lower bound specified, assuming 0
    x1 = model.addVar(name="protein_bars", lb=0)  # No lower bound specified, assuming 0
    x2 = model.addVar(name="lemons", lb=0)  # No lower bound specified, assuming 0

    # Define the objective function
    model.setObjective(9.34 * x0 + 4.2 * x1 + 4.27 * x2, gurobi.GRB.MAXIMIZE)

    # Add constraints
    model.addConstr(6 * x0 + 6 * x1 + 7 * x2 >= 26)
    model.addConstr(18 * x0 + 18 * x1 + 20 * x2 >= 29)
    model.addConstr(6 * x0 + 6 * x1 <= 64)
    model.addConstr(6 * x0 + 7 * x2 <= 98)
    model.addConstr(6 * x0 + 6 * x1 + 7 * x2 <= 98)
    model.addConstr(18 * x0 + 18 * x1 <= 60)
    model.addConstr(18 * x0 + 20 * x2 <= 46)
    model.addConstr(18 * x0 + 18 * x1 + 20 * x2 <= 46)
    model.addConstr(9 * x0 + 17 * x1 <= 155)
    model.addConstr(9 * x0 + 8 * x2 <= 192)
    model.addConstr(9 * x0 + 17 * x1 + 8 * x2 <= 192)

    # Optimize the model
    model.optimize()

    # Print the solution
    if model.status == gurobi.GRB.OPTIMAL:
        print("Objective: ", model.objval)
        print("Fruit Salads: ", x0.varValue)
        print("Protein Bars: ", x1.varValue)
        print("Lemons: ", x2.varValue)
    else:
        print("The model is infeasible")

solve_optimization_problem()
