
import gurobipy as gp
from gurobipy import GRB

try:
    # Create a new model
    m = gp.Model("optimize_work_hours")

    # Create variables
    hank_hours = m.addVar(vtype=GRB.INTEGER, name="hank_hours")
    ringo_hours = m.addVar(vtype=GRB.CONTINUOUS, name="ringo_hours")

    # Set objective function
    m.setObjective(6.31 * hank_hours + 8.64 * ringo_hours, GRB.MAXIMIZE)

    # Add constraints
    m.addConstr(17.41 * hank_hours + 10.0 * ringo_hours >= 49, "dollar_cost_min")
    m.addConstr(2.79 * hank_hours + 2.13 * ringo_hours >= 32, "quit_index_min")
    m.addConstr(5 * hank_hours - 1 * ringo_hours >= 0, "hank_ringo_ratio")
    m.addConstr(17.41 * hank_hours + 10.0 * ringo_hours <= 161, "dollar_cost_max")
    m.addConstr(2.79 * hank_hours + 2.13 * ringo_hours <= 110, "quit_index_max")


    # Optimize model
    m.optimize()

    # Print results
    if m.status == GRB.OPTIMAL:
        print(f"Optimal objective value: {m.objVal}")
        print(f"Hours worked by Hank: {hank_hours.x}")
        print(f"Hours worked by Ringo: {ringo_hours.x}")
    elif m.status == GRB.INFEASIBLE:
        print("The model is infeasible.")
    else:
        print(f"Optimization ended with status {m.status}")


except gp.GurobiError as e:
    print(f"Error code {e.errno}: {e}")

except AttributeError:
    print('Encountered an attribute error')
