
from gurobipy import *

# Create a new model
m = Model("Optimization_Problem")

# Define variables
x1 = m.addVar(vtype=GRB.INTEGER, name="hours_worked_by_Hank")
x2 = m.addVar(vtype=GRB.CONTINUOUS, name="hours_worked_by_Ringo")

# Set objective function
m.setObjective(6.31*x1 + 8.64*x2, GRB.MAXIMIZE)

# Add constraints
m.addConstr(17.41*x1 + 10.0*x2 >= 49, "dollar_cost_min")
m.addConstr(2.79*x1 + 2.13*x2 >= 32, "quit_index_min")
m.addConstr(5*x1 - x2 >= 0, "hank_ringo_ratio")
m.addConstr(17.41*x1 + 10.0*x2 <= 161, "dollar_cost_max")
m.addConstr(2.79*x1 + 2.13*x2 <= 110, "quit_index_max")

# Optimize model
m.optimize()

# Print solution
if m.status == GRB.OPTIMAL:
    print("Optimal solution found:")
    print("Hours worked by Hank:", x1.x)
    print("Hours worked by Ringo:", x2.x)
    print("Objective function value:", m.objVal)
else:
    print("No optimal solution found.")
