
import gurobi

def solve_optimization_problem():
    # Create a new Gurobi model
    model = gurobi.Model()

    # Define the variables
    x1 = model.addVar(name="x1", vtype=gurobi.GRB.INTEGER)  # hours worked by Hank
    x2 = model.addVar(name="x2")  # hours worked by Ringo

    # Define the objective function
    model.setObjective(6.31 * x1 + 8.64 * x2, gurobi.GRB.MAXIMIZE)

    # Define the constraints
    model.addConstr(17.41 * x1 + 10.0 * x2 >= 49)
    model.addConstr(2.79 * x1 + 2.13 * x2 >= 32)
    model.addConstr(5 * x1 - x2 >= 0)
    model.addConstr(17.41 * x1 + 10.0 * x2 <= 161)
    model.addConstr(2.79 * x1 + 2.13 * x2 <= 110)

    # Set bounds for x1 and x2
    model.addConstr(x1 >= 0)
    model.addConstr(x2 >= 0)

    # Solve the model
    model.optimize()

    # Print the solution
    if model.status == gurobi.GRB.OPTIMAL:
        print("Optimal solution found.")
        print(f"Hours worked by Hank: {x1.varValue}")
        print(f"Hours worked by Ringo: {x2.varValue}")
        print(f"Objective function value: {model.objVal}")
    else:
        print("No optimal solution found.")

solve_optimization_problem()
