
import gurobipy as gp

# Create a new model
m = gp.Model("optimization_problem")

# Create variables
cherry_pies = m.addVar(lb=0, vtype=gp.GRB.CONTINUOUS, name="cherry_pies")
bagged_salads = m.addVar(lb=0, vtype=gp.GRB.CONTINUOUS, name="bagged_salads")
green_beans = m.addVar(lb=0, vtype=gp.GRB.CONTINUOUS, name="green_beans")


# Set objective function
m.setObjective(6.26 * cherry_pies + 3.48 * bagged_salads + 2.79 * green_beans, gp.GRB.MINIMIZE)

# Add constraints
m.addConstr(21 * bagged_salads + 23 * green_beans >= 95)
m.addConstr(1 * cherry_pies + 23 * green_beans >= 58)
m.addConstr(1 * cherry_pies + 21 * bagged_salads >= 106)
m.addConstr(1 * cherry_pies + 21 * bagged_salads + 23 * green_beans >= 106)
m.addConstr(22 * bagged_salads + 2 * green_beans >= 31)
m.addConstr(3 * cherry_pies + 22 * bagged_salads >= 14)
m.addConstr(3 * cherry_pies + 22 * bagged_salads + 2 * green_beans >= 14)
m.addConstr(16 * bagged_salads + 6 * green_beans >= 59)
m.addConstr(19 * cherry_pies + 16 * bagged_salads + 6 * green_beans >= 59)
m.addConstr(15 * cherry_pies + 1 * bagged_salads >= 90)
m.addConstr(15 * cherry_pies + 1 * bagged_salads + 3 * green_beans >= 98)
m.addConstr(15 * cherry_pies + 1 * bagged_salads + 3 * green_beans >= 98)
m.addConstr(5 * bagged_salads + 10 * green_beans >= 61)
m.addConstr(10 * cherry_pies + 5 * bagged_salads >= 109)
m.addConstr(10 * cherry_pies + 5 * bagged_salads + 10 * green_beans >= 109)
m.addConstr(1 * bagged_salads - 10 * green_beans >= 0)
m.addConstr(1 * cherry_pies + 21 * bagged_salads <= 144)
m.addConstr(3 * cherry_pies + 22 * bagged_salads <= 90)
m.addConstr(3 * cherry_pies + 2 * green_beans <= 119)
m.addConstr(16 * bagged_salads + 6 * green_beans <= 291)
m.addConstr(19 * cherry_pies + 6 * green_beans <= 164)
m.addConstr(15 * cherry_pies + 1 * bagged_salads + 3 * green_beans <= 307)

# Resource Constraints
m.addConstr(1 * cherry_pies + 21 * bagged_salads + 23 * green_beans <= 318)
m.addConstr(3 * cherry_pies + 22 * bagged_salads + 2 * green_beans <= 125)
m.addConstr(19 * cherry_pies + 16 * bagged_salads + 6 * green_beans <= 292)
m.addConstr(15 * cherry_pies + 1 * bagged_salads + 3 * green_beans <= 329)
m.addConstr(10 * cherry_pies + 5 * bagged_salads + 10 * green_beans <= 382)


# Optimize model
m.optimize()

# Print results
if m.status == gp.GRB.OPTIMAL:
    print('Obj: %g' % m.objVal)
    print('cherry_pies:', cherry_pies.x)
    print('bagged_salads:', bagged_salads.x)
    print('green_beans:', green_beans.x)
elif m.status == gp.GRB.INFEASIBLE:
    print('The model is infeasible.')
else:
    print('Optimization ended with status %d' % m.status)

