
import gurobi

# Create a new model
model = gurobi.Model()

# Define the variables
x0 = model.addVar(name="cherry_pies", lb=0)
x1 = model.addVar(name="bagged_salads", lb=0)
x2 = model.addVar(name="green_beans", lb=0)

# Set the objective function
model.setObjective(6.26 * x0 + 3.48 * x1 + 2.79 * x2, gurobi.GRB.MINIMIZE)

# Add constraints
model.addConstr(21 * x1 + 23 * x2 >= 95)
model.addConstr(x0 + 23 * x2 >= 58)
model.addConstr(x0 + 21 * x1 >= 106)
model.addConstr(x0 + 21 * x1 + 23 * x2 >= 106)
model.addConstr(22 * x1 + 2 * x2 >= 31)
model.addConstr(3 * x0 + 22 * x1 >= 14)
model.addConstr(3 * x0 + 22 * x1 + 2 * x2 >= 14)
model.addConstr(16 * x1 + 6 * x2 >= 59)
model.addConstr(19 * x0 + 16 * x1 + 6 * x2 >= 59)
model.addConstr(15 * x0 + x1 >= 90)
model.addConstr(15 * x0 + x1 + 3 * x2 >= 98)
model.addConstr(5 * x1 + 10 * x2 >= 61)
model.addConstr(10 * x0 + 5 * x1 >= 109)
model.addConstr(10 * x0 + 5 * x1 + 10 * x2 >= 109)
model.addConstr(x1 - 10 * x2 >= 0)
model.addConstr(x0 + 21 * x1 <= 144)
model.addConstr(3 * x0 + 22 * x1 <= 90)
model.addConstr(3 * x0 + 2 * x2 <= 119)
model.addConstr(16 * x1 + 6 * x2 <= 291)
model.addConstr(19 * x0 + 6 * x2 <= 164)
model.addConstr(15 * x0 + x1 + 3 * x2 <= 307)

# Solve the model
model.optimize()

# Print the solution
if model.status == gurobi.GRB.OPTIMAL:
    print("Objective: ", model.objval)
    print("Cherry pies: ", x0.varValue)
    print("Bagged salads: ", x1.varValue)
    print("Green beans: ", x2.varValue)
else:
    print("The model is infeasible")
