
import gurobipy as gp

# Create a new model
model = gp.Model("minimize_work_hours")

# Create variables
bill_hours = model.addVar(vtype=gp.GRB.INTEGER, name="bill_hours")  # Bill's hours (integer)
hank_hours = model.addVar(vtype=gp.GRB.CONTINUOUS, name="hank_hours") # Hank's hours (continuous)

# Set objective function
model.setObjective(7 * bill_hours + 2 * hank_hours, gp.GRB.MINIMIZE)

# Add constraints
model.addConstr(1 * bill_hours + 6 * hank_hours >= 10, "likelihood_to_quit_min")
model.addConstr(5 * bill_hours + 4 * hank_hours >= 15, "computer_competence_min")
model.addConstr(-8 * bill_hours + 8 * hank_hours >= 0, "hours_relation")
model.addConstr(1 * bill_hours + 6 * hank_hours <= 45, "likelihood_to_quit_max")
model.addConstr(5 * bill_hours + 4 * hank_hours <= 49, "computer_competence_max")


# Optimize model
model.optimize()

# Check for infeasibility
if model.status == gp.GRB.INFEASIBLE:
    print("The model is infeasible.")
else:
    # Print optimal solution
    print("Optimal Solution:")
    print(f"Hours worked by Bill: {bill_hours.x}")
    print(f"Hours worked by Hank: {hank_hours.x}")
    print(f"Objective Value: {model.objVal}")

