
import gurobi

# Create a new model
model = gurobi.Model()

# Define the variables
x1 = model.addVar(lb=0, ub=48, name="hours_worked_by_Bill", vtype=gurobi.GRB.INTEGER)
x2 = model.addVar(lb=0, ub=48, name="hours_worked_by_Hank")

# Set the objective function
model.setObjective(7 * x1 + 2 * x2, gurobi.GRB.MINIMIZE)

# Add constraints
model.addConstr(1 * x1 + 6 * x2 >= 10, name="likelihood_to_quit_index")
model.addConstr(5 * x1 + 4 * x2 >= 15, name="computer_competence_rating")
model.addConstr(-8 * x1 + 8 * x2 >= 0, name="hours_worked_constraint")
model.addConstr(1 * x1 + 6 * x2 <= 45, name="likelihood_to_quit_index_upper_bound")
model.addConstr(5 * x1 + 4 * x2 <= 49, name="computer_competence_rating_upper_bound")

# Optimize the model
model.optimize()

# Print the solution
if model.status == gurobi.GRB.OPTIMAL:
    print("Optimal solution found.")
    print(f"Hours worked by Bill: {x1.varValue}")
    print(f"Hours worked by Hank: {x2.varValue}")
    print(f"Objective function value: {model.objVal}")
else:
    print("No optimal solution found.")
