
import gurobipy as gp

try:
    # Create a new model
    model = gp.Model("optimize_work_hours")

    # Create variables
    ringo_hours = model.addVar(vtype=gp.GRB.INTEGER, name="ringo_hours")
    dale_hours = model.addVar(vtype=gp.GRB.CONTINUOUS, name="dale_hours")

    # Set objective function
    model.setObjective(8 * ringo_hours + 4 * dale_hours, gp.GRB.MAXIMIZE)

    # Add constraints
    model.addConstr(10 * ringo_hours + 2 * dale_hours >= 15, "work_quality_min")
    model.addConstr(10 * ringo_hours + 7 * dale_hours >= 42, "computer_competence_min")
    model.addConstr(3 * ringo_hours + 4 * dale_hours >= 9, "likelihood_to_quit_min")
    model.addConstr(2 * ringo_hours - 9 * dale_hours >= 0, "custom_constraint")
    model.addConstr(10 * ringo_hours + 2 * dale_hours <= 48, "work_quality_max")
    model.addConstr(10 * ringo_hours + 7 * dale_hours <= 96, "computer_competence_max")
    model.addConstr(3 * ringo_hours + 4 * dale_hours <= 31, "likelihood_to_quit_max")


    # Optimize model
    model.optimize()

    # Check for infeasibility
    if model.status == gp.GRB.INFEASIBLE:
        print("The model is infeasible.")
    # Print solution if feasible
    elif model.status == gp.GRB.OPTIMAL:
        print('Obj: %g' % model.objVal)
        print('Ringo Hours: %g' % ringo_hours.x)
        print('Dale Hours: %g' % dale_hours.x)


except gp.GurobiError as e:
    print('Error code ' + str(e.errno) + ': ' + str(e))

except AttributeError:
    print('Encountered an attribute error')
