
import gurobi

def solve_optimization_problem():
    # Create a new Gurobi model
    model = gurobi.Model()

    # Define the variables
    x1 = model.addVar(name="x1", vtype=gurobi.GRB.INTEGER)  # hours worked by Ringo
    x2 = model.addVar(name="x2")  # hours worked by Dale

    # Define the objective function
    model.setObjective(8 * x1 + 4 * x2, gurobi.GRB.MAXIMIZE)

    # Add constraints
    model.addConstr(10 * x1 + 2 * x2 >= 15, name="work_quality_rating")
    model.addConstr(10 * x1 + 7 * x2 >= 42, name="computer_competence_rating")
    model.addConstr(3 * x1 + 4 * x2 >= 9, name="likelihood_to_quit_index")
    model.addConstr(2 * x1 - 9 * x2 >= 0, name="relationship_hours_worked")
    model.addConstr(10 * x1 + 2 * x2 <= 48, name="upper_limit_work_quality")
    model.addConstr(10 * x1 + 7 * x2 <= 96, name="upper_limit_computer_competence")
    model.addConstr(3 * x1 + 4 * x2 <= 31, name="upper_limit_likelihood_to_quit")

    # Set bounds for x2 (not necessary but good practice)
    model.addConstr(x2 >= 0)

    # Solve the model
    model.optimize()

    # Print the solution
    if model.status == gurobi.GRB.OPTIMAL:
        print("Optimal solution found.")
        print(f"Hours worked by Ringo: {x1.varValue}")
        print(f"Hours worked by Dale: {x2.varValue}")
        print(f"Objective function value: {model.objVal}")
    else:
        print("No optimal solution found.")

solve_optimization_problem()
