
import gurobipy as gp

try:
    # Create a new model
    m = gp.Model("optimization_problem")

    # Create variables
    x0 = m.addVar(lb=0, vtype=gp.GRB.CONTINUOUS, name="x0")  # milligrams of vitamin B9
    x1 = m.addVar(lb=0, vtype=gp.GRB.CONTINUOUS, name="x1")  # milligrams of magnesium
    x2 = m.addVar(lb=0, vtype=gp.GRB.CONTINUOUS, name="x2")  # milligrams of calcium


    # Set objective function
    m.setObjective(2.05 * x0 + 9.06 * x1 + 5.68 * x2, gp.GRB.MAXIMIZE)

    # Add constraints
    m.addConstr(6.95 * x0 + 2.8 * x1 + 5.16 * x2 >= 23, "c0")
    m.addConstr(9.98 * x0 + 7.57 * x1 + 2.62 * x2 >= 42, "c1")
    m.addConstr(6.95 * x0 + 2.8 * x1 <= 77, "c2")
    m.addConstr(2.8 * x1 + 5.16 * x2 <= 48, "c3")
    m.addConstr(6.95 * x0 + 2.8 * x1 + 5.16 * x2 <= 117, "c4")
    m.addConstr(15.5 * x1 + 9.45 * x2 <= 112, "c5")
    m.addConstr(15.5 * x0 + 7.18 * x1 <= 267, "c6")
    m.addConstr(15.5 * x0 + 7.18 * x1 + 9.45 * x2 <= 310, "c7")
    m.addConstr(9.98 * x0 + 2.62 * x2 <= 85, "c8")
    m.addConstr(7.57 * x1 + 2.62 * x2 <= 116, "c9")


    # Optimize model
    m.optimize()

    if m.status == gp.GRB.OPTIMAL:
        print('Obj: %g' % m.objVal)
        for v in m.getVars():
            print('%s %g' % (v.varName, v.x))
    elif m.status == gp.GRB.INFEASIBLE:
        print('Optimization problem is infeasible.')
    else:
        print('Optimization ended with status %d' % m.status)


except gp.GurobiError as e:
    print('Error code ' + str(e.errno) + ': ' + str(e))

except AttributeError:
    print('Encountered an attribute error')
