
import gurobi

def optimize_problem():
    model = gurobi.Model()

    # Define variables
    x1 = model.addVar(name="x1", lb=0)  # milligrams of vitamin B9
    x2 = model.addVar(name="x2", lb=0)  # milligrams of magnesium
    x3 = model.addVar(name="x3", lb=0)  # milligrams of calcium

    # Objective function
    model.setObjective(2.05 * x1 + 9.06 * x2 + 5.68 * x3, gurobi.GRB.MAXIMIZE)

    # Constraints
    model.addConstr(6.95 * x1 <= 129)
    model.addConstr(15.5 * x1 <= 311)
    model.addConstr(9.98 * x1 <= 190)
    model.addConstr(2.8 * x2 <= 129)
    model.addConstr(7.18 * x2 <= 311)
    model.addConstr(7.57 * x2 <= 190)
    model.addConstr(5.16 * x3 <= 129)
    model.addConstr(9.45 * x3 <= 311)
    model.addConstr(2.62 * x3 <= 190)
    model.addConstr(6.95 * x1 + 2.8 * x2 + 5.16 * x3 >= 23)
    model.addConstr(9.98 * x1 + 7.57 * x2 + 2.62 * x3 >= 42)
    model.addConstr(6.95 * x1 + 2.8 * x2 <= 77)
    model.addConstr(2.8 * x2 + 5.16 * x3 <= 48)
    model.addConstr(6.95 * x1 + 2.8 * x2 + 5.16 * x3 <= 117)
    model.addConstr(7.18 * x2 + 9.45 * x3 <= 112)
    model.addConstr(15.5 * x1 + 7.18 * x2 <= 267)
    model.addConstr(15.5 * x1 + 7.18 * x2 + 9.45 * x3 <= 310)
    model.addConstr(9.98 * x1 + 2.62 * x3 <= 85)
    model.addConstr(7.57 * x2 + 2.62 * x3 <= 116)
    model.addConstr(9.98 * x1 + 7.57 * x2 + 2.62 * x3 <= 116)

    # Solve the model
    model.optimize()

    # Print the solution
    if model.status == gurobi.GRB.OPTIMAL:
        print("Optimal solution found.")
        print(f"Milligrams of vitamin B9: {x1.varValue}")
        print(f"Milligrams of magnesium: {x2.varValue}")
        print(f"Milligrams of calcium: {x3.varValue}")
        print(f"Objective function value: {model.objVal}")
    else:
        print("No optimal solution found.")

optimize_problem()
