
import gurobipy as gp

# Create a new model
m = gp.Model("food_optimization")

# Create variables
ham_sandwiches = m.addVar(lb=0, vtype=gp.GRB.CONTINUOUS, name="ham_sandwiches")
protein_bars = m.addVar(lb=0, vtype=gp.GRB.CONTINUOUS, name="protein_bars")
rotisserie_chickens = m.addVar(lb=0, vtype=gp.GRB.CONTINUOUS, name="rotisserie_chickens")
oreos = m.addVar(lb=0, vtype=gp.GRB.CONTINUOUS, name="oreos")

# Set objective function
m.setObjective(4.35 * ham_sandwiches + 4.6 * protein_bars + 5.73 * rotisserie_chickens + 2.05 * oreos, gp.GRB.MAXIMIZE)

# Add constraints
m.addConstr(14 * ham_sandwiches + 6 * rotisserie_chickens + 11 * oreos >= 34, "protein_constraint1")
m.addConstr(14 * ham_sandwiches + 17 * protein_bars + 6 * rotisserie_chickens >= 34, "protein_constraint2")
m.addConstr(14 * ham_sandwiches + 6 * rotisserie_chickens + 11 * oreos >= 45, "protein_constraint3")
m.addConstr(14 * ham_sandwiches + 17 * protein_bars + 6 * rotisserie_chickens >= 45, "protein_constraint4")
m.addConstr(2 * ham_sandwiches + 18 * protein_bars >= 20, "carbohydrate_constraint1")
m.addConstr(18 * protein_bars + 7 * oreos >= 24, "carbohydrate_constraint2")
m.addConstr(11 * rotisserie_chickens + 7 * oreos >= 20, "carbohydrate_constraint3")
m.addConstr(2 * ham_sandwiches + 11 * rotisserie_chickens + 7 * oreos >= 25, "carbohydrate_constraint4")
m.addConstr(2 * ham_sandwiches + 18 * protein_bars + 11 * rotisserie_chickens >= 25, "carbohydrate_constraint5")
m.addConstr(2 * ham_sandwiches + 11 * rotisserie_chickens + 7 * oreos >= 27, "carbohydrate_constraint6")
m.addConstr(2 * ham_sandwiches + 18 * protein_bars + 11 * rotisserie_chickens >= 27, "carbohydrate_constraint7")
m.addConstr(2 * ham_sandwiches + 6 * rotisserie_chickens + 1 * oreos >= 37, "iron_constraint1")
m.addConstr(14 * protein_bars + 6 * rotisserie_chickens + 1 * oreos >= 37, "iron_constraint2")
m.addConstr(2 * ham_sandwiches + 6 * rotisserie_chickens + 1 * oreos >= 35, "iron_constraint3")
m.addConstr(14 * protein_bars + 6 * rotisserie_chickens + 1 * oreos >= 35, "iron_constraint4")
m.addConstr(2 * ham_sandwiches + 3 * protein_bars + 7 * oreos >= 41, "healthiness_constraint1")
m.addConstr(2 * ham_sandwiches + 4 * rotisserie_chickens + 7 * oreos >= 41, "healthiness_constraint2")
m.addConstr(3 * protein_bars + 4 * rotisserie_chickens + 7 * oreos >= 41, "healthiness_constraint3")
m.addConstr(2 * ham_sandwiches + 3 * protein_bars + 7 * oreos >= 24, "healthiness_constraint4")
m.addConstr(2 * ham_sandwiches + 4 * rotisserie_chickens + 7 * oreos >= 24, "healthiness_constraint5")
m.addConstr(3 * protein_bars + 4 * rotisserie_chickens + 7 * oreos >= 24, "healthiness_constraint6")
m.addConstr(2 * ham_sandwiches + 3 * protein_bars + 7 * oreos >= 42, "healthiness_constraint7")
m.addConstr(2 * ham_sandwiches + 4 * rotisserie_chickens + 7 * oreos >= 42, "healthiness_constraint8")
m.addConstr(3 * protein_bars + 4 * rotisserie_chickens + 7 * oreos >= 42, "healthiness_constraint9")


#upper bounds from combined resources
m.addConstr(14 * ham_sandwiches + 17 * protein_bars <= 205, "protein_upper_bound1")
m.addConstr(14 * ham_sandwiches + 11 * oreos <= 216, "protein_upper_bound2")
m.addConstr(17 * protein_bars + 11 * oreos <= 123, "protein_upper_bound3")
m.addConstr(17 * protein_bars + 6 * rotisserie_chickens + 11 * oreos <= 180, "protein_upper_bound4")
m.addConstr(14 * ham_sandwiches + 17 * protein_bars + 6 * rotisserie_chickens + 11 * oreos <= 180, "protein_upper_bound5")
m.addConstr(2 * ham_sandwiches + 7 * oreos <= 58, "carbohydrate_upper_bound1")
m.addConstr(18 * protein_bars + 11 * rotisserie_chickens <= 66, "carbohydrate_upper_bound2")
m.addConstr(2 * ham_sandwiches + 18 * protein_bars + 11 * rotisserie_chickens + 7 * oreos <= 66, "carbohydrate_upper_bound3")
m.addConstr(6 * rotisserie_chickens + 1 * oreos <= 262, "iron_upper_bound1")
m.addConstr(14 * protein_bars + 1 * oreos <= 273, "iron_upper_bound2")
m.addConstr(2 * ham_sandwiches + 1 * oreos <= 211, "iron_upper_bound3")
m.addConstr(2 * ham_sandwiches + 6 * rotisserie_chickens + 1 * oreos <= 126, "iron_upper_bound4")
m.addConstr(2 * ham_sandwiches + 14 * protein_bars + 6 * rotisserie_chickens + 1 * oreos <= 126, "iron_upper_bound5")
m.addConstr(2 * ham_sandwiches + 4 * rotisserie_chickens <= 163, "healthiness_upper_bound1")
m.addConstr(2 * ham_sandwiches + 7 * oreos <= 43, "healthiness_upper_bound2")
m.addConstr(2 * ham_sandwiches + 4 * rotisserie_chickens + 7 * oreos <= 50, "healthiness_upper_bound3")
m.addConstr(3 * protein_bars + 4 * rotisserie_chickens + 7 * oreos <= 102, "healthiness_upper_bound4")
m.addConstr(2 * ham_sandwiches + 3 * protein_bars + 7 * oreos <= 118, "healthiness_upper_bound5")
m.addConstr(2 * ham_sandwiches + 3 * protein_bars + 4 * rotisserie_chickens + 7 * oreos <= 118, "healthiness_upper_bound6")

#individual upper bounds
m.addConstr(14 * ham_sandwiches <= 266, "protein_individual_upper_bound1")
m.addConstr(18 * protein_bars <= 131, "carbohydrate_individual_upper_bound2")
m.addConstr(6 * rotisserie_chickens <= 286, "iron_individual_upper_bound3")
m.addConstr(7 * oreos <= 171, "healthiness_individual_upper_bound4")
m.addConstr(2 * ham_sandwiches <= 286, "iron_individual_upper_bound1")
m.addConstr(14 * protein_bars <= 286, "iron_individual_upper_bound2")
m.addConstr(6 * rotisserie_chickens <= 286, "iron_individual_upper_bound3")
m.addConstr(1 * oreos <= 286, "iron_individual_upper_bound4")
m.addConstr(2 * ham_sandwiches <= 171, "healthiness_individual_upper_bound1")
m.addConstr(3 * protein_bars <= 171, "healthiness_individual_upper_bound2")
m.addConstr(4 * rotisserie_chickens <= 171, "healthiness_individual_upper_bound3")
m.addConstr(7 * oreos <= 171, "healthiness_individual_upper_bound4")



# Optimize model
m.optimize()

# Print results
if m.status == gp.GRB.OPTIMAL:
    print('Obj: %g' % m.objVal)
    for v in m.getVars():
        print('%s %g' % (v.varName, v.x))
else:
    print("Infeasible")

