
import gurobi

# Define the model
m = gurobi.Model()

# Define the variables
x1 = m.addVar(name="ham_sandwiches", lb=0)
x2 = m.addVar(name="protein_bars", lb=0)
x3 = m.addVar(name="rotisserie_chickens", lb=0)
x4 = m.addVar(name="oreos", lb=0)

# Define the objective function
m.setObjective(4.35 * x1 + 4.6 * x2 + 5.73 * x3 + 2.05 * x4, gurobi.GRB.MAXIMIZE)

# Add constraints
m.addConstr(14 * x1 + 6 * x3 + 11 * x4 >= 34)
m.addConstr(14 * x1 + 17 * x2 + 6 * x3 >= 34)
m.addConstr(14 * x1 + 6 * x3 + 11 * x4 >= 45)
m.addConstr(14 * x1 + 17 * x2 + 6 * x3 >= 45)
m.addConstr(2 * x1 + 18 * x2 >= 20)
m.addConstr(18 * x2 + 7 * x4 >= 24)
m.addConstr(11 * x3 + 7 * x4 >= 20)
m.addConstr(2 * x1 + 11 * x3 + 7 * x4 >= 25)
m.addConstr(2 * x1 + 18 * x2 + 11 * x3 >= 25)
m.addConstr(2 * x1 + 11 * x3 + 7 * x4 >= 27)
m.addConstr(2 * x1 + 18 * x2 + 11 * x3 >= 27)
m.addConstr(2 * x1 + 6 * x3 + x4 >= 37)
m.addConstr(14 * x2 + 6 * x3 + x4 >= 37)
m.addConstr(2 * x1 + 6 * x3 + x4 >= 35)
m.addConstr(14 * x2 + 6 * x3 + x4 >= 35)
m.addConstr(2 * x1 + 3 * x2 + 7 * x4 >= 41)
m.addConstr(2 * x1 + 4 * x3 + 7 * x4 >= 41)
m.addConstr(3 * x2 + 4 * x3 + 7 * x4 >= 41)
m.addConstr(2 * x1 + 3 * x2 + 7 * x4 >= 24)
m.addConstr(2 * x1 + 4 * x3 + 7 * x4 >= 24)
m.addConstr(3 * x2 + 4 * x3 + 7 * x4 >= 24)
m.addConstr(2 * x1 + 3 * x2 + 7 * x4 >= 42)
m.addConstr(2 * x1 + 4 * x3 + 7 * x4 >= 42)
m.addConstr(3 * x2 + 4 * x3 + 7 * x4 >= 42)
m.addConstr(14 * x1 + 17 * x2 <= 205)
m.addConstr(14 * x1 + 11 * x4 <= 216)
m.addConstr(17 * x2 + 11 * x4 <= 123)
m.addConstr(17 * x2 + 6 * x3 + 11 * x4 <= 180)
m.addConstr(14 * x1 + 17 * x2 + 6 * x3 + 11 * x4 <= 180)
m.addConstr(2 * x1 + 7 * x4 <= 58)
m.addConstr(18 * x2 + 11 * x3 <= 66)
m.addConstr(2 * x1 + 18 * x2 + 11 * x3 + 7 * x4 <= 66)
m.addConstr(6 * x3 + x4 <= 262)
m.addConstr(14 * x2 + x4 <= 273)
m.addConstr(2 * x1 + x4 <= 211)
m.addConstr(2 * x1 + 6 * x3 + x4 <= 126)
m.addConstr(2 * x1 + 18 * x2 + 6 * x3 + x4 <= 126)
m.addConstr(2 * x1 + 4 * x3 <= 163)
m.addConstr(2 * x1 + 7 * x4 <= 43)
m.addConstr(2 * x1 + 4 * x3 + 7 * x4 <= 50)
m.addConstr(3 * x2 + 4 * x3 + 7 * x4 <= 102)
m.addConstr(2 * x1 + 3 * x2 + 7 * x4 <= 118)
m.addConstr(2 * x1 + 3 * x2 + 4 * x3 + 7 * x4 <= 118)

# Solve the model
m.optimize()

# Print the solution
if m.status == gurobi.GRB.OPTIMAL:
    print("Objective: ", m.objVal)
    print("Ham sandwiches: ", x1.varValue)
    print("Protein bars: ", x2.varValue)
    print("Rotisserie chickens: ", x3.varValue)
    print("Oreos: ", x4.varValue)
else:
    print("The model is infeasible")
