
import gurobipy as gp
from gurobipy import GRB

try:
    # Create a new model
    m = gp.Model("optimization_problem")

    # Create variables
    x0 = m.addVar(vtype=GRB.INTEGER, name="manila_envelopes")
    x1 = m.addVar(vtype=GRB.INTEGER, name="hole_punches")


    # Set objective function
    m.setObjective(6.04 * x0 + 3.72 * x1, GRB.MINIMIZE)

    # Add constraints
    m.addConstr(12 * x0 + 14 * x1 >= 26, "cost_lower_bound")
    m.addConstr(1 * x0 + 14 * x1 >= 9, "storage_lower_bound")
    m.addConstr(8 * x0 + 8 * x1 >= 39, "safety_lower_bound")
    m.addConstr(6 * x0 + 4 * x1 >= 38, "satisfaction_lower_bound")
    m.addConstr(5 * x0 - 3 * x1 >= 0, "custom_constraint")

    m.addConstr(12 * x0 + 14 * x1 <= 55, "cost_upper_bound")
    m.addConstr(1 * x0 + 14 * x1 <= 42, "storage_upper_bound")
    m.addConstr(8 * x0 + 8 * x1 <= 43, "safety_upper_bound")
    m.addConstr(6 * x0 + 4 * x1 <= 83, "satisfaction_upper_bound")



    # Optimize model
    m.optimize()

    # Print results
    if m.status == GRB.OPTIMAL:
        print('Obj: %g' % m.objVal)
        print('manila_envelopes:', x0.x)
        print('hole_punches:', x1.x)
    elif m.status == GRB.INFEASIBLE:
        print('The model is infeasible.')
    else:
        print('Optimization ended with status %d' % m.status)


except gp.GurobiError as e:
    print('Error code ' + str(e.errno) + ': ' + str(e))

except AttributeError:
    print('Encountered an attribute error')
