
from gurobipy import *

# Create a model
m = Model("Optimization_Problem")

# Define variables
x1 = m.addVar(vtype=GRB.INTEGER, name="manila_envelopes")
x2 = m.addVar(vtype=GRB.INTEGER, name="hole_punches")

# Set objective function
m.setObjective(6.04*x1 + 3.72*x2, GRB.MINIMIZE)

# Add constraints
m.addConstr(12*x1 + 14*x2 >= 26, "cost_constraint")
m.addConstr(x1 + 14*x2 >= 9, "storage_space_lower_bound")
m.addConstr(8*x1 + 8*x2 >= 39, "workplace_safety_impact_lower_bound")
m.addConstr(6*x1 + 4*x2 >= 38, "employee_satisfaction_impact_lower_bound")
m.addConstr(5*x1 - 3*x2 >= 0, "additional_linear_constraint")
m.addConstr(12*x1 + 14*x2 <= 55, "budget_upper_bound")
m.addConstr(x1 + 14*x2 <= 42, "storage_space_upper_bound")
m.addConstr(8*x1 + 8*x2 <= 43, "workplace_safety_impact_upper_bound")
m.addConstr(6*x1 + 4*x2 <= 83, "employee_satisfaction_impact_upper_bound")

# Optimize model
m.optimize()

# Print solution
if m.status == GRB.OPTIMAL:
    print("Optimal solution found:")
    print(f"Manila envelopes: {x1.x}")
    print(f"Hole punches: {x2.x}")
    print(f"Objective function value: {m.objVal}")
else:
    print("No optimal solution found")
