
import gurobi

def solve_optimization_problem():
    # Create a new Gurobi model
    model = gurobi.Model()

    # Define the variables
    x1 = model.addVar(name='manila_envelopes', vtype=gurobi.GRB.INTEGER)
    x2 = model.addVar(name='hole_punches', vtype=gurobi.GRB.INTEGER)

    # Objective function
    model.setObjective(6.04 * x1 + 3.72 * x2, gurobi.GRB.MINIMIZE)

    # Constraints
    model.addConstr(12 * x1 + 14 * x2 >= 26)
    model.addConstr(x1 + 14 * x2 >= 9)
    model.addConstr(8 * x1 + 8 * x2 >= 39)
    model.addConstr(6 * x1 + 4 * x2 >= 38)
    model.addConstr(5 * x1 - 3 * x2 >= 0)
    model.addConstr(12 * x1 + 14 * x2 <= 55)
    model.addConstr(x1 + 14 * x2 <= 42)
    model.addConstr(8 * x1 + 8 * x2 <= 43)
    model.addConstr(6 * x1 + 4 * x2 <= 83)

    # Optimize the model
    model.optimize()

    # Print the solution
    if model.status == gurobi.GRB.OPTIMAL:
        print('Objective: ', model.objval)
        print('Manila envelopes: ', x1.varValue)
        print('Hole punches: ', x2.varValue)
    else:
        print('The model is infeasible')

solve_optimization_problem()
