
import gurobipy as gp

# Create a new model
m = gp.Model("optimization_problem")

# Create variables
candles = m.addVar(vtype=gp.GRB.INTEGER, name="candles")
paper_towel_rolls = m.addVar(vtype=gp.GRB.INTEGER, name="paper_towel_rolls")
packs_of_paper_plates = m.addVar(vtype=gp.GRB.INTEGER, name="packs_of_paper_plates")
lightbulbs = m.addVar(vtype=gp.GRB.INTEGER, name="lightbulbs")

# Set objective function
m.setObjective(3.07 * candles + 7.66 * paper_towel_rolls + 1.18 * packs_of_paper_plates + 5.04 * lightbulbs, gp.GRB.MAXIMIZE)

# Add constraints
m.addConstr(candles + paper_towel_rolls + 9 * packs_of_paper_plates + 2 * lightbulbs <= 169, "c0")
m.addConstr(4 * candles + 6 * paper_towel_rolls + 5 * packs_of_paper_plates + 6 * lightbulbs <= 186, "c1")
m.addConstr(6 * candles + 8 * paper_towel_rolls + packs_of_paper_plates + 3 * lightbulbs <= 220, "c2")
m.addConstr(8 * candles + 8 * paper_towel_rolls + 10 * packs_of_paper_plates + 7 * lightbulbs <= 100, "c3")
m.addConstr(candles + 9 * packs_of_paper_plates >= 28, "c4")
m.addConstr(9 * packs_of_paper_plates + 2 * lightbulbs >= 34, "c5")
m.addConstr(paper_towel_rolls + 9 * packs_of_paper_plates >= 42, "c6")
m.addConstr(6 * paper_towel_rolls + 5 * packs_of_paper_plates >= 45, "c7")
m.addConstr(5 * packs_of_paper_plates + 6 * lightbulbs >= 30, "c8")
m.addConstr(6 * candles + packs_of_paper_plates + 3 * lightbulbs >= 36, "c9")
m.addConstr(6 * candles + 8 * paper_towel_rolls + packs_of_paper_plates >= 36, "c10")
m.addConstr(6 * candles + packs_of_paper_plates + 3 * lightbulbs >= 27, "c11")
m.addConstr(6 * candles + 8 * paper_towel_rolls + packs_of_paper_plates >= 27, "c12")
m.addConstr(8 * candles + 7 * lightbulbs >= 16, "c13")
m.addConstr(8 * candles + 10 * packs_of_paper_plates >= 13, "c14")
m.addConstr(8 * candles + 8 * paper_towel_rolls + 7 * lightbulbs >= 14, "c15")
m.addConstr(8 * candles + 8 * paper_towel_rolls + 10 * packs_of_paper_plates >= 14, "c16")
m.addConstr(8 * candles + 8 * paper_towel_rolls + 7 * lightbulbs >= 13, "c17")
m.addConstr(8 * candles + 8 * paper_towel_rolls + 10 * packs_of_paper_plates >= 13, "c18")
m.addConstr(paper_towel_rolls + 9 * packs_of_paper_plates <= 101, "c19")
m.addConstr(paper_towel_rolls + 2 * lightbulbs <= 132, "c20")
m.addConstr(candles + 9 * packs_of_paper_plates <= 157, "c21")
m.addConstr(candles + paper_towel_rolls + 2 * lightbulbs <= 121, "c22")
m.addConstr(candles + paper_towel_rolls + 9 * packs_of_paper_plates + 2 * lightbulbs <= 121, "c23")
m.addConstr(4 * candles + 6 * paper_towel_rolls <= 176, "c24")
m.addConstr(4 * candles + 6 * paper_towel_rolls + 6 * lightbulbs <= 76, "c25")
m.addConstr(4 * candles + 5 * packs_of_paper_plates + 6 * lightbulbs <= 112, "c26")
m.addConstr(4 * candles + 6 * paper_towel_rolls + 5 * packs_of_paper_plates + 6 * lightbulbs <= 112, "c27")
m.addConstr(8 * paper_towel_rolls + packs_of_paper_plates <= 142, "c28")
m.addConstr(packs_of_paper_plates + 3 * lightbulbs <= 99, "c29")
m.addConstr(6 * candles + packs_of_paper_plates <= 156, "c30")
m.addConstr(6 * candles + 8 * paper_towel_rolls + packs_of_paper_plates + 3 * lightbulbs <= 156, "c31")
m.addConstr(8 * paper_towel_rolls + 7 * lightbulbs <= 36, "c32")
m.addConstr(8 * candles + 10 * packs_of_paper_plates <= 95, "c33")
m.addConstr(8 * candles + 8 * paper_towel_rolls + 10 * packs_of_paper_plates <= 100, "c34")
m.addConstr(8 * candles + 8 * paper_towel_rolls + 10 * packs_of_paper_plates + 7 * lightbulbs <= 100, "c35")


# Optimize model
m.optimize()

# Print results
if m.status == gp.GRB.OPTIMAL:
    print('Obj: %g' % m.objVal)
    for v in m.getVars():
        print('%s %g' % (v.varName, v.x))
elif m.status == gp.GRB.INFEASIBLE:
    print("The model is infeasible.")
else:
    print("Optimization ended with status %d" % m.status)

