
import gurobi

# Create a new model
m = gurobi.Model()

# Define the variables
x0 = m.addVar(name='candles', vtype='I')
x1 = m.addVar(name='paper_towel_rolls', vtype='I')
x2 = m.addVar(name='packs_of_paper_plates', vtype='I')
x3 = m.addVar(name='lightbulbs', vtype='I')

# Define the objective function
m.setObjective(3.07 * x0 + 7.66 * x1 + 1.18 * x2 + 5.04 * x3, gurobi.GRB.MAXIMIZE)

# Add constraints
m.addConstr(x0 + x1 + 9 * x2 + 2 * x3 <= 169)
m.addConstr(4 * x0 + 6 * x1 + 5 * x2 + 6 * x3 <= 186)
m.addConstr(6 * x0 + 8 * x1 + x2 + 3 * x3 <= 220)
m.addConstr(8 * x0 + 8 * x1 + 10 * x2 + 7 * x3 <= 100)

m.addConstr(x0 + 9 * x2 >= 28)
m.addConstr(9 * x2 + 2 * x3 >= 34)
m.addConstr(x1 + 9 * x2 >= 42)
m.addConstr(6 * x1 + 5 * x2 >= 45)
m.addConstr(5 * x2 + 6 * x3 >= 30)
m.addConstr(6 * x0 + x2 + 3 * x3 >= 36)
m.addConstr(6 * x0 + 8 * x1 + x2 >= 36)
m.addConstr(6 * x0 + x2 + 3 * x3 >= 27)
m.addConstr(6 * x0 + 8 * x1 + x2 >= 27)
m.addConstr(8 * x0 + 7 * x3 >= 16)
m.addConstr(8 * x0 + 10 * x2 >= 13)
m.addConstr(8 * x0 + 8 * x1 + 7 * x3 >= 14)
m.addConstr(8 * x0 + 8 * x1 + 10 * x2 >= 14)
m.addConstr(8 * x0 + 8 * x1 + 7 * x3 >= 13)
m.addConstr(8 * x0 + 8 * x1 + 10 * x2 >= 13)

m.addConstr(x1 + 9 * x2 <= 101)
m.addConstr(x1 + 2 * x3 <= 132)
m.addConstr(x0 + 9 * x2 <= 157)
m.addConstr(x0 + x1 + 2 * x3 <= 121)
m.addConstr(x0 + x1 + 9 * x2 + 2 * x3 <= 121)
m.addConstr(4 * x0 + 6 * x1 <= 176)
m.addConstr(4 * x0 + 6 * x1 + 6 * x3 <= 76)
m.addConstr(4 * x0 + 5 * x2 + 6 * x3 <= 112)
m.addConstr(4 * x0 + 6 * x1 + 5 * x2 + 6 * x3 <= 112)
m.addConstr(8 * x1 + x2 <= 142)
m.addConstr(x2 + 3 * x3 <= 99)
m.addConstr(6 * x0 + x2 <= 156)
m.addConstr(6 * x0 + 8 * x1 + x2 + 3 * x3 <= 156)
m.addConstr(8 * x1 + 7 * x3 <= 36)
m.addConstr(8 * x0 + 10 * x2 <= 95)
m.addConstr(8 * x0 + 8 * x1 + 10 * x2 <= 100)
m.addConstr(8 * x0 + 8 * x1 + 10 * x2 + 7 * x3 <= 100)

# Solve the model
m.optimize()

# Print the solution
if m.status == gurobi.GRB.OPTIMAL:
    print('Objective: ', m.objVal)
    print('Candles: ', x0.varValue)
    print('Paper Towel Rolls: ', x1.varValue)
    print('Packs of Paper Plates: ', x2.varValue)
    print('Lightbulbs: ', x3.varValue)
else:
    print('No solution found')
