
import gurobipy as gp
from gurobipy import GRB

try:
    # Create a new model
    m = gp.Model("optimization_problem")

    # Create variables
    x0 = m.addVar(name="hours worked by Paul")
    x1 = m.addVar(name="hours worked by Jean")


    # Set objective function
    m.setObjective(8.11 * x0 + 8.33 * x1, GRB.MINIMIZE)

    # Add constraints
    m.addConstr(1.18 * x0 + 3.74 * x1 >= 40, "c0")
    m.addConstr(6.04 * x0 + 5.88 * x1 >= 89, "c1")
    m.addConstr(1.18 * x0 + 6.64 * x1 >= 33, "c2")
    m.addConstr(2 * x0 - 3 * x1 >= 0, "c3")
    m.addConstr(1.18 * x0 + 3.74 * x1 <= 133, "c4")
    m.addConstr(6.04 * x0 + 5.88 * x1 <= 195, "c5")
    m.addConstr(1.18 * x0 + 6.64 * x1 <= 110, "c6")



    # Optimize model
    m.optimize()

    if m.status == GRB.OPTIMAL:
        print('Obj: %g' % m.objVal)
        for v in m.getVars():
            print('%s %g' % (v.varName, v.x))
    elif m.status == GRB.INFEASIBLE:
        print('Optimization problem is infeasible.')
    else:
        print('Optimization ended with status %d' % m.status)


except gp.GurobiError as e:
    print('Error code ' + str(e.errno) + ': ' + str(e))

except AttributeError:
    print('Encountered an attribute error')
