
from gurobipy import *

# Create a new model
m = Model("Optimization_Problem")

# Define variables
x1 = m.addVar(name="hours_worked_by_Paul", lb=0)
x2 = m.addVar(name="hours_worked_by_Jean", lb=0)

# Set the objective function
m.setObjective(8.11*x1 + 8.33*x2, GRB.MINIMIZE)

# Add constraints
m.addConstr(1.18*x1 + 3.74*x2 >= 40, name="productivity_rating")
m.addConstr(6.04*x1 + 5.88*x2 >= 89, name="work_quality_rating")
m.addConstr(1.18*x1 + 6.64*x2 >= 33, name="organization_score")
m.addConstr(2*x1 - 3*x2 >= 0, name="linear_constraint")
m.addConstr(1.18*x1 + 3.74*x2 <= 133, name="upper_bound_productivity")
m.addConstr(6.04*x1 + 5.88*x2 <= 195, name="upper_bound_work_quality")
m.addConstr(1.18*x1 + 6.64*x2 <= 110, name="upper_bound_organization")

# Optimize the model
m.optimize()

# Print solution
if m.status == GRB.OPTIMAL:
    print("Optimal solution found:")
    print(f"Hours worked by Paul: {x1.x}")
    print(f"Hours worked by Jean: {x2.x}")
    print(f"Objective function value: {m.objVal}")
else:
    print("No optimal solution found")
