
import gurobi

# Define the model
model = gurobi.Model()

# Define the variables
x1 = model.addVar(name="hours_worked_by_Paul", lb=0)  # Lower bound is 0, assuming hours cannot be negative
x2 = model.addVar(name="hours_worked_by_Jean", lb=0)  # Lower bound is 0, assuming hours cannot be negative

# Define the objective function
model.setObjective(8.11 * x1 + 8.33 * x2, gurobi.GRB.MINIMIZE)

# Add constraints
model.addConstr(1.18 * x1 + 3.74 * x2 >= 40)
model.addConstr(6.04 * x1 + 5.88 * x2 >= 89)
model.addConstr(1.18 * x1 + 6.64 * x2 >= 33)
model.addConstr(2 * x1 - 3 * x2 >= 0)
model.addConstr(1.18 * x1 + 3.74 * x2 <= 133)
model.addConstr(6.04 * x1 + 5.88 * x2 <= 195)
model.addConstr(1.18 * x1 + 6.64 * x2 <= 110)

# Optimize the model
model.optimize()

# Print the solution
if model.status == gurobi.GRB.OPTIMAL:
    print("Optimal solution found.")
    print(f"Hours worked by Paul: {x1.varValue}")
    print(f"Hours worked by Jean: {x2.varValue}")
    print(f"Objective function value: {model.objVal}")
else:
    print("No optimal solution found.")
