
import gurobipy as gp

try:
    # Create a new model
    model = gp.Model("Work_Optimization")

    # Create variables
    mary_hours = model.addVar(lb=0, name="mary_hours")  # Continuous variable
    george_hours = model.addVar(lb=0, vtype=gp.GRB.INTEGER, name="george_hours") # Integer variable


    # Set objective function
    model.setObjective(2.09 * mary_hours + 2.23 * george_hours, gp.GRB.MAXIMIZE)

    # Add constraints
    model.addConstr(3 * mary_hours + 10 * george_hours >= 33, "paperwork_rating_min")
    model.addConstr(5 * mary_hours - 6 * george_hours >= 0, "work_balance")
    model.addConstr(3 * mary_hours + 10 * george_hours <= 169, "paperwork_rating_max")


    # Optimize model
    model.optimize()

    # Check for infeasibility
    if model.status == gp.GRB.INFEASIBLE:
        print("The model is infeasible.")
    else:
        # Print optimal solution
        print("Optimal Solution:")
        print(f"Hours worked by Mary: {mary_hours.x}")
        print(f"Hours worked by George: {george_hours.x}")
        print(f"Objective Value: {model.objVal}")

except gp.GurobiError as e:
    print(f"Error code {e.errno}: {e}")

except AttributeError:
    print('Encountered an attribute error')
