
from gurobipy import *

# Create a model
m = Model("Optimization_Problem")

# Define variables
x1 = m.addVar(vtype=GRB.CONTINUOUS, name='hours_worked_by_Mary')
x2 = m.addVar(vtype=GRB.INTEGER, name='hours_worked_by_George')

# Set objective function
m.setObjective(2.09*x1 + 2.23*x2, GRB.MAXIMIZE)

# Add constraints
m.addConstr(3*x1 + 10*x2 >= 33, 'paperwork_rating_min')
m.addConstr(5*x1 - 6*x2 >= 0, 'mary_george_ratio')
m.addConstr(3*x1 + 10*x2 <= 169, 'paperwork_rating_max')

# Optimize the model
m.optimize()

# Print solution
if m.status == GRB.OPTIMAL:
    print("Optimal solution found:")
    print(f"Hours worked by Mary: {x1.x}")
    print(f"Hours worked by George: {x2.x}")
    print(f"Objective Function Value: {m.objVal}")
else:
    print("No optimal solution found")
