
import gurobi

def solve_optimization_problem():
    # Create a new model
    model = gurobi.Model()

    # Define the variables
    x1 = model.addVar(name='hours_worked_by_Mary', lb=0)  # No upper bound for x1
    x2 = model.addVar(name='hours_worked_by_George', lb=0, vtype=gurobi.GRB.INTEGER)

    # Set the objective function
    model.setObjective(2.09 * x1 + 2.23 * x2, gurobi.GRB.MAXIMIZE)

    # Add constraints
    model.addConstr(3 * x1 + 10 * x2 >= 33)
    model.addConstr(5 * x1 - 6 * x2 >= 0)
    model.addConstr(3 * x1 + 10 * x2 <= 169)

    # Optimize the model
    model.optimize()

    # Print the solution
    if model.status == gurobi.GRB.OPTIMAL:
        print('Optimal solution found.')
        print(f'Hours worked by Mary: {x1.varValue}')
        print(f'Hours worked by George: {x2.varValue}')
        print(f'Objective function value: {model.objVal}')
    else:
        print('No optimal solution found.')

solve_optimization_problem()
